/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Copyright (c) 2006-2007, LIPP Alliance
 *
 * All Rights Reserved.
 *
 *---------------------------------------------------------------------------
 * %filename:             tmbslPhyAccess.c %
 * %pid_version:             1.2                  %
 *---------------------------------------------------------------------------
 * DESCRIPTION:  PHY interface file for Linux Ethernet driver
 *
 * DOCUMENT REF: 
 *
 * NOTES:        This is to be updated if there is change in PHY hardware
 *               Appropriate APIs are to be repopulated in the array.
 *
 *-----------------------------------------------------------------------------
 *
*/
#include "tmbslPhy.h" /* tmbslPhyConfig_t declaration */
#include "tmhwLIPP6100Eth_Cfg.h" /* For TMHWLIPP6100ETH_NUM_UNITS */

/* lipp_6300eth_common.h has PHY macros definitions __USING_<phy name>_PHY__*/
#include "lipp_6300eth_common.h" 

#define LAN_CLK_SEL        0
#define LAN_CLK_SPEED_SEL  0

#ifdef __USING_SMSC8700_PHY__
#include "tmbslPhySMSC8700.h" /* For function prototypes of PHY*/
/* PHY interface structure to store PHY register access functions */    
 tmbslPhyConfig_t gtmbslPhyInterface[TMHWLIPP6100ETH_NUM_UNITS] = 
{
    {  "SMSC8700",
        LAN_CLK_SEL,
        LAN_CLK_SPEED_SEL,
        tmbslPhySMSC8700GetSWVersion, 
        tmbslPhySMSC8700GetCapabilities,
        tmbslPhySMSC8700Init,
        tmbslPhySMSC8700Deinit,  
        tmbslPhySMSC8700SetPowerState,
        tmbslPhySMSC8700GetPowerState,
        tmbslPhySMSC8700GetBasicModeControl,
        tmbslPhySMSC8700SetBasicModeControl,
        tmbslPhySMSC8700GetBasicModeStatus,
        tmbslPhySMSC8700AutoNegotiate,
        Null,
        Null,
        Null,
        Null,
        Null,
        Null,
        Null,
        tmbslPhySMSC8700LoopBack,
        tmbslPhySMSC8700SoftReset,
        tmbslPhySMSC8700GetLinkStatus
    }

};

#endif

#ifdef __USING_SMSC8710_PHY__
#include "tmbslPhySMSC8710.h" /* For function prototypes of PHY*/
/* PHY interface structure to store PHY register access functions */    
 tmbslPhyConfig_t gtmbslPhyInterface[TMHWLIPP6100ETH_NUM_UNITS] = 
{
    {  "SMSC8710",
        LAN_CLK_SEL,
        LAN_CLK_SPEED_SEL,
        tmbslPhySMSC8710GetSWVersion, 
        tmbslPhySMSC8710GetCapabilities,
        tmbslPhySMSC8710Init,
        tmbslPhySMSC8710Deinit,  
        tmbslPhySMSC8710SetPowerState,
        tmbslPhySMSC8710GetPowerState,
        tmbslPhySMSC8710GetBasicModeControl,
        tmbslPhySMSC8710SetBasicModeControl,
        tmbslPhySMSC8710GetBasicModeStatus,
        tmbslPhySMSC8710AutoNegotiate,
        Null,
        Null,
        Null,
        Null,
        Null,
        Null,
        Null,
        tmbslPhySMSC8710LoopBack,
        tmbslPhySMSC8710SoftReset,
        tmbslPhySMSC8710GetLinkStatus
    }

};

#endif

#ifdef  __USING_DP83848_PHY__
#include "tmbslPhyDP83848.h"
/* PHY interface structure to store PHY register access functions */    
 tmbslPhyConfig_t gtmbslPhyInterface[TMHWLIPP6100ETH_NUM_UNITS] = 
{
    {  "DP83848",
        LAN_CLK_SEL,
        LAN_CLK_SPEED_SEL,
        tmbslPhyDP83848GetSWVersion, 
        tmbslPhyDP83848GetCapabilities,
        tmbslPhyDP83848Init,
        tmbslPhyDP83848Deinit,  
        tmbslPhyDP83848SetPowerState,
        tmbslPhyDP83848GetPowerState,
        tmbslPhyDP83848GetBasicModeControl,
        tmbslPhyDP83848SetBasicModeControl,
        tmbslPhyDP83848GetBasicModeStatus,
        tmbslPhyDP83848AutoNegotiate,
        Null,
        Null,
        Null,
        Null,
        Null,
        Null,
        Null,
        tmbslPhyDP83848LoopBack,
        tmbslPhyDP83848SoftReset,
        tmbslPhyDP83848GetLinkStatus
    }

};

#endif

#ifdef __USING_DP83865_PHY__
#include "tmbslPhyDP83865.h"
/* PHY interface structure to store PHY register access functions */    
 tmbslPhyConfig_t gtmbslPhyInterface[TMHWLIPP6100ETH_NUM_UNITS] = 
{
    {  "DP83865",
        LAN_CLK_SEL,
        LAN_CLK_SPEED_SEL,
        tmbslPhyDP83865GetSWVersion, 
        tmbslPhyDP83865GetCapabilities,
        tmbslPhyDP83865Init,
        tmbslPhyDP83865Deinit,  
        tmbslPhyDP83865SetPowerState,
        tmbslPhyDP83865GetPowerState,
        tmbslPhyDP83865GetBasicModeControl,
        tmbslPhyDP83865SetBasicModeControl,
        tmbslPhyDP83865GetBasicModeStatus,
        tmbslPhyDP83865AutoNegotiate,
        Null,
        Null,
        Null,
        Null,
        Null,
        Null,
        Null,
        tmbslPhyDP83865LoopBack,
        tmbslPhyDP83865SoftReset,
        tmbslPhyDP83865GetLinkStatus
    }

};
#endif

#ifdef __USING_EMU_PHY__
#include "tmbslPhyEmu.h"
/* PHY interface structure to store PHY register access functions */    
 tmbslPhyConfig_t gtmbslPhyInterface[TMHWLIPP6100ETH_NUM_UNITS] = 
{
    {  "EMULATOR",
        LAN_CLK_SEL,
        LAN_CLK_SPEED_SEL,
        tmbslPhyEmuGetSWVersion, 
        tmbslPhyEmuGetCapabilities,
        tmbslPhyEmuInit,
        tmbslPhyEmuDeinit,  
        tmbslPhyEmuSetPowerState,
        tmbslPhyEmuGetPowerState,
        tmbslPhyEmuGetBasicModeControl,
        tmbslPhyEmuSetBasicModeControl,
        tmbslPhyEmuGetBasicModeStatus,
        tmbslPhyEmuAutoNegotiate,
        Null,
        Null,
        Null,
        Null,
        Null,
        Null,
        Null,
        tmbslPhyEmuLoopBack,
        tmbslPhyEmuSoftReset,
        tmbslPhyEmuGetLinkStatus
    }

};

#endif


void tmbslPhyGetInterface(int unitnumber, tmbslPhyConfig_t ** pPhyInterface)
{
     *(pPhyInterface) = &gtmbslPhyInterface[unitnumber];
}


