/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Copyright (c) 2006-2007, LIPP Alliance
 * All Rights Reserved.
 *
 *---------------------------------------------------------------------------
 * %filename:     tmhwLIPP6100Eth_Vhip.h %
 * %pid_version:          1.5                           %
 *---------------------------------------------------------------------------
 * DESCRIPTION:   vHAL file for ethernet HwApi driver
 *
 *  DOCUMENT REF: Synopsys DesignWare Ethernet Universal Databook 
 *                         Version 3.41a, Feb 2008 
 *
 * NOTES:        None
 *
 *-----------------------------------------------------------------------------
 *
*/

#ifndef TMHWLIPP6100ETH_VHIP_H
#define TMHWLIPP6100ETH_VHIP_H

/*-----------------------------------------------------------------------------
* Standard include files:
*-----------------------------------------------------------------------------
*/

#include "tmhwLIPP6100Eth_Cfg.h"

#ifdef __cplusplus
extern "C" {  /* Assume C declarations for C++ */
#endif


/* Registers offsets of GMAC */
#define TMVH_LIPP6100ETH_CONFIG_REG_OFFSET (0x0000)

#define TMVH_LIPP6100ETH_CONFIG_TXCONFIG_VAL (0x1000000U)
#define TMVH_LIPP6100ETH_CONFIG_TXCONFIG_POS (24)

#define TMVH_LIPP6100ETH_CONFIG_WD_VAL (0x800000U)
#define TMVH_LIPP6100ETH_CONFIG_WD_POS (23)

#define TMVH_LIPP6100ETH_CONFIG_JD_VAL (0x400000U)
#define TMVH_LIPP6100ETH_CONFIG_JD_POS (22)

#define TMVH_LIPP6100ETH_CONFIG_FBE_VAL (0x200000U)
#define TMVH_LIPP6100ETH_CONFIG_FBE_POS (21)


#define TMVH_LIPP6100ETH_CONFIG_JFE_VAL (0x100000U)
#define TMVH_LIPP6100ETH_CONFIG_JFE_POS (20)

#define TMVH_LIPP6100ETH_CONFIG_DISCS_VAL (0x10000U)
#define TMVH_LIPP6100ETH_CONFIG_DISCS_POS (16)

#define TMVH_LIPP6100ETH_CONFIG_IFG_MSK (0xE0000U)
#define TMVH_LIPP6100ETH_CONFIG_IFG_POS (17)

#define TMVH_LIPP6100ETH_CONFIG_MII_VAL (0x8000U)
#define TMVH_LIPP6100ETH_CONFIG_MII_POS (14)

#define TMVH_LIPP6100ETH_CONFIG_FES_VAL (0x4000U)
#define TMVH_LIPP6100ETH_CONFIG_FES_POS (14)

/* Disable Receive Own */
#define TMVH_LIPP6100ETH_CONFIG_DRXOWN_VAL (0x2000U)
#define TMVH_LIPP6100ETH_CONFIG_DRXOWN_POS (13)

#define TMVH_LIPP6100ETH_CONFIG_LPBK_VAL (0x1000U)
#define TMVH_LIPP6100ETH_CONFIG_LPBK_POS (12)
#define TMVH_LIPP6100ETH_CONFIG_LPBK_CLR (0xFFFFEFFFU) 

#define TMVH_LIPP6100ETH_CONFIG_DUPLEX_VAL (0x800U)
#define TMVH_LIPP6100ETH_CONFIG_DUPLEX_POS (11)

#define TMVH_LIPP6100ETH_CONFIG_IPCCHK_VAL (0x400U)
#define TMVH_LIPP6100ETH_CONFIG_IPCCHK_POS (10)

#define TMVH_LIPP6100ETH_CONFIG_DRETRY_VAL (0x200U)
#define TMVH_LIPP6100ETH_CONFIG_DRETRY_POS (9)

#define TMVH_LIPP6100ETH_CONFIG_LNKUP_VAL (0x100U)

/* Automatic PAD/CRC stripping */
#define TMVH_LIPP6100ETH_CONFIG_ACS_VAL (0x80U)
#define TMVH_LIPP6100ETH_CONFIG_ACS_POS (7)

#define TMVH_LIPP6100ETH_CONFIG_BACKOFF_MSK (0x60U)
#define TMVH_LIPP6100ETH_CONFIG_BACKOFF_POS (5)

#define TMVH_LIPP6100ETH_CONFIG_DEFCHK_VAL (0x10U)
#define TMVH_LIPP6100ETH_CONFIG_DEFCHK_POS (4)

#define TMVH_LIPP6100ETH_CONFIG_TX_EN_VAL (0x8U)
#define TMVH_LIPP6100ETH_CONFIG_TX_EN_CLR (0xFFFFFFF7U)

#define TMVH_LIPP6100ETH_CONFIG_RX_EN_VAL (0x4U)
#define TMVH_LIPP6100ETH_CONFIG_RX_EN_CLR (0xFFFFFFFBU)

#define TMVH_LIPP6100ETH_FMFLTR_REG_OFFSET (0x0004)

#define TMVH_LIPP6100ETH_FMFLTR_RX_ALL_VAL (0x80000000U)
#define TMVH_LIPP6100ETH_FMFLTR_RX_ALL_POS (31)

#define TMVH_LIPP6100ETH_FMFLTR_HASH_N_PER_EN_VAL (0x400U)
#define TMVH_LIPP6100ETH_FMFLTR_HASH_N_PER_EN_POS (10)

#define TMVH_LIPP6100ETH_FMFLTR_SAF_VAL (0x200U)
#define TMVH_LIPP6100ETH_FMFLTR_SAF_POS (9)

#define TMVH_LIPP6100ETH_FMFLTR_SAIF_VAL (0x100U)
#define TMVH_LIPP6100ETH_FMFLTR_SAIF_POS (8)

#define TMVH_LIPP6100ETH_FMFLTR_PCF_POS (6)
#define TMVH_LIPP6100ETH_FMFLTR_PCF_MSK (0xC0U)


#define TMVH_LIPP6100ETH_FMFLTR_DBF_VAL (0x20U)
#define TMVH_LIPP6100ETH_FMFLTR_DBF_POS (5)

#define TMVH_LIPP6100ETH_FMFLTR_PM_VAL (0x10U)
#define TMVH_LIPP6100ETH_FMFLTR_PM_POS (4)

#define TMVH_LIPP6100ETH_FMFLTR_DAIF_VAL (0x8U)
#define TMVH_LIPP6100ETH_FMFLTR_DAIF_POS (3)

#define TMVH_LIPP6100ETH_FMFLTR_HMC_VAL (0x4U)
#define TMVH_LIPP6100ETH_FMFLTR_HMC_POS (2)

#define TMVH_LIPP6100ETH_FMFLTR_HUC_VAL (0x2U)
#define TMVH_LIPP6100ETH_FMFLTR_HUC_POS (1)

#define TMVH_LIPP6100ETH_FMFLTR_PR_VAL (0x1U)


#define TMVH_LIPP6100ETH_HASHTBL_HIGH_REG_OFFSET (0x0008)
#define TMVH_LIPP6100ETH_HASHTBL_LOW_REG_OFFSET (0x000C)

#define TMVH_LIPP6100ETH_GMII_ADDRESS_REG_OFFSET (0x0010)
#define TMVH_LIPP6100ETH_GMII_PHY_ADDRESS_CLR (0xffff07ffU)
#define TMVH_LIPP6100ETH_GMII_PHY_ADDRESS_MSK (0xF800)

/* PHY address value is in  the configuraiton file */
#define TMVH_LIPP6100ETH_GMII_PHY_ADDRESS_POS (11)
#define TMVH_LIPP6100ETH_GMII_ADDRESS_CSR_POS (2)
#define TMVH_LIPP6100ETH_GMII_ADDRESS_CSR_CLR (0xffffffe3U)
#define TMVH_LIPP6100ETH_GMII_ADDRESS_CSR_MSK (0x1CU)
/* CSR value is in the configuration file */

#define TMVH_LIPP6100ETH_GMII_DATA_REG_OFFSET (0x0014)

#define TMVH_LIPP6100ETH_FLOWCTRL_REG_OFFSET (0x0018)
#define TMVH_LIPP6100ETH_FLOWCTRL_PAUSET_MSK (0xFFFF0000U)
#define TMVH_LIPP6100ETH_FLOWCTRL_PAUSET_POS (16)
#define TMVH_LIPP6100ETH_FLOWCTRL_ZEROQ_VAL (0x40)
#define TMVH_LIPP6100ETH_FLOWCTRL_PLT_POS (4)
#define TMVH_LIPP6100ETH_FLOWCTRL_PLT_MSK (0x30U)

#define TMVH_LIPP6100ETH_FLOWCTRL_UP_VAL (0x8U)

#define TMVH_LIPP6100ETH_FLOWCTRL_RFE_VAL (0x4U)

#define TMVH_LIPP6100ETH_FLOWCTRL_TFE_VAL (0x2U)

#define TMVH_LIPP6100ETH_FLOWCTRL_FCBBPA_VAL (0x1U)
#define TMVH_LIPP6100ETH_FLOWCTRL_FCBBPA_CLR (0xFFFFFFFEU)

#define TMVH_LIPP6100ETH_VLANTAG_REG_OFFSET (0x001C)
#define TMVH_LIPP6100ETH_VLANTAG_MASK (0xFFFFU)

#define TMVH_LIPP6100ETH_VERSION_REG_OFFSET (0x0020)
/*(0x0024) Reserved */
#define TMVH_LIPP6100ETH_WKUP_FMFILTER_REG_OFFSET (0x0028)

#define TMVH_LIPP6100ETH_WKUP_FMFILTER_RSTREG_VAL (0x80000000U)

#if (TMFL_LIPP6100ETHSD_POWER || TMFL_SD_ALL)
/* Power management register */
#define TMVH_LIPP6100ETH_PWRMGMT_CTRLSTAT_REG_OFFSET (0x002C)
#define TMVH_LIPP6100ETH_PWRMGMT_GU_VAL (0x200U)
#define TMVH_LIPP6100ETH_PWRMGMT_WKUP_FM_EN_VAL (0x4U)
#define TMVH_LIPP6100ETH_PWRMGMT_MAGIC_PKT_EN_VAL (0x2U)

#define TMVH_LIPP6100ETH_PWRMGMT_POWERDN_EN_VAL (0x1U)
#define TMVH_LIPP6100ETH_PWRMGMT_POWERDN_EN_MSK (0x1U)
#define TMVH_LIPP6100ETH_PWRMGMT_POWERDN_EN_CLR (0xFFFFFFFEU)

#define TMVH_LIPP6100ETH_POWER_ON (0x0U)
#define TMVH_LIPP6100ETH_POWER_OFF (0x1U)

#endif

/* 0x30 to 0x34, reserved */

/* Interrupt status register */
#define TMVH_LIPP6100ETH_INTR_STATUS_REG_OFFSET (0x0038)

/* Interrupt mask register */
#define TMVH_LIPP6100ETH_INTR_MASK_REG_OFFSET (0x003C)

/* Perfect filter registers */
#define TMVH_LIPP6100ETH_ADDR0_HIGH_REG_OFFSET (0x0040)
#define TMVH_LIPP6100ETH_ADDR0_HIGH_REG_MSK (0xFFFFU)
#define TMVH_LIPP6100ETH_ADDR0_LOW_REG_OFFSET (0x0044)

#define TMVH_LIPP6100ETH_ADDR_ENABLE_VAL (0x80000000U)
#define TMVH_LIPP6100ETH_ADDR_SA_EN_VAL (0x40000000U)
#define TMVH_LIPP6100ETH_ADDR_MBC_POS (24)
#define TMVH_LIPP6100ETH_ADDR_MBC_MSK (0x3F000000U)
#define TMVH_LIPP6100ETH_ADDR_MBC_CLR (0xc0ffffffU)
#define TMVH_LIPP6100ETH_ADDR_HIGH_REG_MSK (0xFFFFU)

#define TMVH_LIPP6100ETH_ADDR1_HIGH_REG_OFFSET (0x0048)
#define TMVH_LIPP6100ETH_ADDR1_LOW_REG_OFFSET (0x004C)

#define TMVH_LIPP6100ETH_ADDR2_HIGH_REG_OFFSET (0x0050)
#define TMVH_LIPP6100ETH_ADDR2_LOW_REG_OFFSET (0x0054)

#define TMVH_LIPP6100ETH_ADDR3_HIGH_REG_OFFSET (0x0058)
#define TMVH_LIPP6100ETH_ADDR3_LOW_REG_OFFSET (0x005C)

#define TMVH_LIPP6100ETH_ADDR4_HIGH_REG_OFFSET (0x0060)
#define TMVH_LIPP6100ETH_ADDR4_LOW_REG_OFFSET (0x0064)

#define TMVH_LIPP6100ETH_ADDR5_HIGH_REG_OFFSET (0x0068)
#define TMVH_LIPP6100ETH_ADDR5_LOW_REG_OFFSET (0x006C)


#define TMVH_LIPP6100ETH_ADDR6_HIGH_REG_OFFSET (0x0070)
#define TMVH_LIPP6100ETH_ADDR6_LOW_REG_OFFSET (0x0074)

#define TMVH_LIPP6100ETH_ADDR7_HIGH_REG_OFFSET (0x0078)
#define TMVH_LIPP6100ETH_ADDR7_LOW_REG_OFFSET (0x007C)

#define TMVH_LIPP6100ETH_ADDR8_HIGH_REG_OFFSET (0x0080)
#define TMVH_LIPP6100ETH_ADDR8_LOW_REG_OFFSET (0x0084)

#define TMVH_LIPP6100ETH_ADDR9_HIGH_REG_OFFSET (0x0088)
#define TMVH_LIPP6100ETH_ADDR9_LOW_REG_OFFSET (0x008C)

#define TMVH_LIPP6100ETH_ADDR10_HIGH_REG_OFFSET (0x0090)
#define TMVH_LIPP6100ETH_ADDR10_LOW_REG_OFFSET (0x0094)


#define TMVH_LIPP6100ETH_ADDR11_HIGH_REG_OFFSET (0x0098)
#define TMVH_LIPP6100ETH_ADDR11_LOW_REG_OFFSET (0x009C)

#define TMVH_LIPP6100ETH_ADDR12_HIGH_REG_OFFSET (0x00A0)
#define TMVH_LIPP6100ETH_ADDR12_LOW_REG_OFFSET (0x00A4)

#define TMVH_LIPP6100ETH_ADDR13_HIGH_REG_OFFSET (0x00A8)
#define TMVH_LIPP6100ETH_ADDR13_LOW_REG_OFFSET (0x00AC)


#define TMVH_LIPP6100ETH_ADDR14_HIGH_REG_OFFSET (0x00B0)
#define TMVH_LIPP6100ETH_ADDR14_LOW_REG_OFFSET (0x00B4)

#define TMVH_LIPP6100ETH_ADDR15_HIGH_REG_OFFSET (0x00B8)
#define TMVH_LIPP6100ETH_ADDR15_LOW_REG_OFFSET (0x00BC)

#define TMVH_LIPP6100ETH_ADDR16_HIGH_REG_OFFSET (0x0800)
#define TMVH_LIPP6100ETH_ADDR16_LOW_REG_OFFSET (0x0804)


/* Auto negotiation registers */
#define TMVH_LIPP6100ETH_AN_CTRL_REG_OFFSET (0x00C0)
#define TMVH_LIPP6100ETH_AN_STAT_REG_OFFSET (0x00C4)

#define TMVH_LIPP6100ETH_AN_ADV_REG_OFFSET (0x00C8)
#define TMVH_LIPP6100ETH_AN_LPA_REG_OFFSET (0x00CC)

#define TMVH_LIPP6100ETH_AN_XPAN_REG_OFFSET (0x00D0)

#define TMVH_LIPP6100ETH_TBI_EXTD_STAT_REG_OFFSET (0x00D4)
#define TMVH_LIPP6100ETH_SGMII_RGMII_STAT_REG_OFFSET (0x00D8)


/* DMA register offsets */
#define TMVH_LIPP6100ETH_BUS_MODE_REG_OFFSET (0x1000)
#define TMVH_LIPP6100ETH_BUS_MODE_4XPBL_VAL (0x1000000U)
#define TMVH_LIPP6100ETH_BUS_MODE_SEPPBL_VAL (0x800000U)

#define TMVH_LIPP6100ETH_BUS_MODE_RX_PBL_POS (17)

#define TMVH_LIPP6100ETH_BUS_MODE_AAL_VAL (0x2000000U)

#define TMVH_LIPP6100ETH_BUS_MODE_FB_VAL (0x10000U)

#define TMVH_LIPP6100ETH_BUS_MODE_PR_POS (14)
#define TMVH_LIPP6100ETH_BUS_MODE_PBL_POS (8)

#define TMVH_LIPP6100ETH_BUS_MODE_DSL_POS (2)
#define TMVH_LIPP6100ETH_BUS_MODE_DSL_MSK (0x7CU)

#define TMVH_LIPP6100ETH_BUS_MODE_DA_VAL (0x2U)

#define TMVH_LIPP6100ETH_BUS_MODE_RESET_VAL (0x1U)

#define TMVH_LIPP6100ETH_TXMT_DMD_REG_OFFSET (0x1004)
#define TMVH_LIPP6100ETH_RECV_DMD_REG_OFFSET (0x1008)

#define TMVH_LIPP6100ETH_RXDESC_LISTADDR_REG_OFFSET (0x100C) 

#define TMVH_LIPP6100ETH_TXDESC_LISTADDR_REG_OFFSET (0x1010) 

#define TMVH_LIPP6100ETH_DMA_STATUS_REG_OFFSET (0x1014) 

#define TMVH_LIPP6100ETH_OPERN_MODE_REG_OFFSET (0x1018) 

#define TMVH_LIPP6100ETH_OPERN_MODE_DT_VAL (0x4000000U)
#define TMVH_LIPP6100ETH_OPERN_MODE_RSF_VAL (0x2000000U)

#define TMVH_LIPP6100ETH_OPERN_MODE_FRM_FLUSH_DIS_VAL (0x1000000U)
#define TMVH_LIPP6100ETH_OPERN_MODE_TX_EN_VAL (0x2000U)
#define TMVH_LIPP6100ETH_OPERN_MODE_TX_EN_CLR (0xFFFFDFFFU)
#define TMVH_LIPP6100ETH_OPERN_MODE_RX_EN_VAL (0x2U)
#define TMVH_LIPP6100ETH_OPERN_MODE_RX_EN_CLR (0xFFFFFFFDU)

#define TMVH_LIPP6100ETH_OPERN_MODE_SF_VAL (0x200000U)
#define TMVH_LIPP6100ETH_OPERN_MODE_FTF_VAL (0x100000U)

#define TMVH_LIPP6100ETH_OPERN_MODE_TTC_POS (14)
#define TMVH_LIPP6100ETH_OPERN_MODE_TTC_MSK (0x1C000U)
#define TMVH_LIPP6100ETH_OPERN_MODE_TTC_CLR (0xFFFE3FFFU)

#define TMVH_LIPP6100ETH_OPERN_MODE_RFD_POS (11)
#define TMVH_LIPP6100ETH_OPERN_MODE_RFD2_POS (22)
#define TMVH_LIPP6100ETH_OPERN_MODE_RFD2_VAL (0x400000U)
#define TMVH_LIPP6100ETH_OPERN_MODE_RFD_MSK (0x1800U)
#define TMVH_LIPP6100ETH_OPERN_MODE_RFD_CLR (0xFFFFE7FFU)

#define TMVH_LIPP6100ETH_OPERN_MODE_RFA_POS (9)
#define TMVH_LIPP6100ETH_OPERN_MODE_RFA2_POS (23)
#define TMVH_LIPP6100ETH_OPERN_MODE_RFA2_VAL (0x800000U)
#define TMVH_LIPP6100ETH_OPERN_MODE_RFA_MSK (0x600U)
#define TMVH_LIPP6100ETH_OPERN_MODE_RFA_CLR (0xFFFFF9FFU)
#define TMVH_LIPP6100ETH_OPERN_MODE_MSB_CLR (0xFFFFFFFBU)

#define TMVH_LIPP6100ETH_OPERN_MODE_EFC_VAL (0x100U)

#define TMVH_LIPP6100ETH_OPERN_MODE_FEF_VAL (0x80U)
#define TMVH_LIPP6100ETH_OPERN_MODE_FUF_VAL (0x40U)

#define TMVH_LIPP6100ETH_OPERN_MODE_RTC_POS (3)
#define TMVH_LIPP6100ETH_OPERN_MODE_RTC_MSK (0x18U)
#define TMVH_LIPP6100ETH_OPERN_MODE_RTC_CLR (0xFFFFFFE7U)

#define TMVH_LIPP6100ETH_OPERN_MODE_OSF_VAL (0x4U)

#define TMVH_LIPP6100ETH_DMA_INT_ENABLE_REG_OFFSET (0x101C)

/*
Offsets 0x1024 to 0x1044 are reserved.
*/
#if (TMFL_LIPP6100ETHSD_OTHERS || TMFL_SD_ALL)

#define TMVH_LIPP6100ETH_MISSFR_BUFOVRFLOW_CNT_REG_OFFSET (0x1020)
#define TMVH_LIPP6100ETH_MISSFR_FIFO_CNT_POS (17)
#define TMVH_LIPP6100ETH_MISSFR_FIFO_CNT_MSK (0xffe0000U)
#define TMVH_LIPP6100ETH_MISSFR_BUF_CNT_MSK (0xFFFF)

#define TMVH_LIPP6100ETH_CUR_HOST_TX_DESC_REG_OFFSET (0x1048)
#define TMVH_LIPP6100ETH_CUR_HOST_RX_DESC_REG_OFFSET (0x104C)

#define TMVH_LIPP6100ETH_CUR_HOST_TXBUFADR_REG_OFFSET (0x1050)
#define TMVH_LIPP6100ETH_CUR_HOST_RXBUFADR_REG_OFFSET (0x1054)

#endif

#if (TMFL_LIPP6100ETHSD_MMC || TMFL_SD_ALL)
/* Mac Management Counter register offsets */
#define TMVH_LIPP6100ETH_MMC_CTRL_REG_OFFSET (0x100)
#define TMVH_LIPP6100ETH_MMC_CTRL_CNTR_FREZ_VAL (0x8U)
#define TMVH_LIPP6100ETH_MMC_CTRL_CNTR_RESET_VAL (0x1U)
#define TMVH_LIPP6100ETH_MMC_CTRL_RESET_ON_RD_VAL (0x4U)
#define TMVH_LIPP6100ETH_MMC_CTRL_STOP_ROLLOVER_VAL (0x2U)

#define TMVH_LIPP6100ETH_MMC_INTR_RX_REG_OFFSET (0x104)
#define TMVH_LIPP6100ETH_MMC_INTR_TX_REG_OFFSET (0x108)

#define TMVH_LIPP6100ETH_MMC_INTR_TXMASK_REG_OFFSET (0x10C)
#define TMVH_LIPP6100ETH_MMC_INTR_RXMASK_REG_OFFSET (0x110)

/* Counters  on Transmission side */

#define TMVH_LIPP6100ETH_MMC_TXOCTET_CNT_GB_REG_OFFSET (0x114)

#define TMVH_LIPP6100ETH_MMC_TXFRAME_CNT_GB_REG_OFFSET (0x118)

#define TMVH_LIPP6100ETH_MMC_TXBRDCST_CNT_G_REG_OFFSET (0x11C)

#define TMVH_LIPP6100ETH_MMC_TXMULTCST_CNT_G_REG_OFFSET (0x120)

#define TMVH_LIPP6100ETH_MMC_TX64_GB_REG_OFFSET (0x124)

#define TMVH_LIPP6100ETH_MMC_TX65TO127_GB_REG_OFFSET (0x128)

#define TMVH_LIPP6100ETH_MMC_TX128TO255_GB_REG_OFFSET (0x12C)

#define TMVH_LIPP6100ETH_MMC_TX256TO511_GB_REG_OFFSET (0x130)

#define TMVH_LIPP6100ETH_MMC_TX512TO1023_GB_REG_OFFSET (0x134)

#define TMVH_LIPP6100ETH_MMC_TX1024TOMAX_GB_REG_OFFSET (0x138)

#define TMVH_LIPP6100ETH_MMC_TX_UNICAST_GB_REG_OFFSET (0x13C)

#define TMVH_LIPP6100ETH_MMC_TX_MULTCST_GB_REG_OFFSET (0x140)

#define TMVH_LIPP6100ETH_MMC_TX_BRDCST_GB_REG_OFFSET (0x144)

#define TMVH_LIPP6100ETH_MMC_TX_UNNDERFLOW_ERR_REG_OFFSET (0x148)

#define TMVH_LIPP6100ETH_MMC_TX_SINGLCOL_G_REG_OFFSET (0x14C)

#define TMVH_LIPP6100ETH_MMC_TX_MULTICOL_G_REG_OFFSET (0x150)

#define TMVH_LIPP6100ETH_MMC_TX_DEFERRED_REG_OFFSET (0x154)

#define TMVH_LIPP6100ETH_MMC_TX_LATECOL_REG_OFFSET (0x158)

#define TMVH_LIPP6100ETH_MMC_TX_EXCESSCOL_REG_OFFSET (0x15C)

#define TMVH_LIPP6100ETH_MMC_TX_CARRIER_ERR_REG_OFFSET (0x160)

#define TMVH_LIPP6100ETH_MMC_TX_OCTET_CNT_G_REG_OFFSET (0x164)

#define TMVH_LIPP6100ETH_MMC_TX_FRM_CNT_G_REG_OFFSET (0x168)

#define TMVH_LIPP6100ETH_MMC_TX_EXCESS_DEF_REG_OFFSET (0x16C)

#define TMVH_LIPP6100ETH_MMC_TX_PAUSE_FRAMES_REG_OFFSET (0x170)

#define TMVH_LIPP6100ETH_MMC_TX_VLAN_FRAMES_G_REG_OFFSET (0x174)

/*
0x1078 --0x107C reserved
*/

/* Received frames */
#define TMVH_LIPP6100ETH_MMC_RXFRM_CNT_GB_REG_OFFSET (0x180)
#define TMVH_LIPP6100ETH_MMC_RXOCTET_CNT_GB_REG_OFFSET (0x184)
#define TMVH_LIPP6100ETH_MMC_RXOCTET_CNT_G_REG_OFFSET (0x188)

#define TMVH_LIPP6100ETH_MMC_RX_BRDCSTF_G_REG_OFFSET (0x18C)

#define TMVH_LIPP6100ETH_MMC_RX_MULTCSTF_G_REG_OFFSET (0x190)

#define TMVH_LIPP6100ETH_MMC_RX_CRC_ERR_REG_OFFSET (0x194)

#define TMVH_LIPP6100ETH_MMC_RX_ALIGNMT_ERR_REG_OFFSET (0x198)

#define TMVH_LIPP6100ETH_MMC_RX_RUNT_ERR_REG_OFFSET (0x19C)

#define TMVH_LIPP6100ETH_MMC_RX_JABBER_ERR_REG_OFFSET (0x1A0)

#define TMVH_LIPP6100ETH_MMC_RX_UNDERSIZE_G_REG_OFFSET (0x1A4)

#define TMVH_LIPP6100ETH_MMC_RX_OVERSIZE_G_REG_OFFSET (0x1A8)

#define TMVH_LIPP6100ETH_MMC_RX_64_GB_REG_OFFSET (0x1AC)

#define TMVH_LIPP6100ETH_MMC_RX_65TO127_GB_REG_OFFSET (0x1B0)

#define TMVH_LIPP6100ETH_MMC_RX_128TO255_GB_REG_OFFSET (0x1B4)

#define TMVH_LIPP6100ETH_MMC_RX_256TO511_GB_REG_OFFSET (0x1B8)

#define TMVH_LIPP6100ETH_MMC_RX_512TO1023_GB_REG_OFFSET (0x1BC)

#define TMVH_LIPP6100ETH_MMC_RX_1024TOMAX_GB_REG_OFFSET (0x1C0)

#define TMVH_LIPP6100ETH_MMC_RX_UNICAST_G_REG_OFFSET (0x1C4)

#define TMVH_LIPP6100ETH_MMC_RX_LEN_ERR_REG_OFFSET (0x1C8)

#define TMVH_LIPP6100ETH_MMC_RX_OUTOFRANGE_REG_OFFSET (0x1CC)

#define TMVH_LIPP6100ETH_MMC_RX_PAUSE_REG_OFFSET (0x1D0)

#define TMVH_LIPP6100ETH_MMC_RX_FIFO_OVERFLOW_REG_OFFSET (0x1D4)

#define TMVH_LIPP6100ETH_MMC_RX_VLAN_FRAMES_GB_REG_OFFSET (0x1D8)

#define TMVH_LIPP6100ETH_MMC_RX_WATCHDOG_ERR_REG_OFFSET (0x1DC)


/* IPv4, IPv6, TCP, UDP, ICMP statistics counters */

/* 0x01E0 -- 0x01FC reserved */

#define TMVH_LIPP6100ETH_MMC_IPC_INTMASK_REG_OFFSET (0x200)

/* 0x204  reserved */

#define TMVH_LIPP6100ETH_MMC_IPC_INT_REG_OFFSET (0x208)

/* 0x020C reserved */
#define TMVH_LIPP6100ETH_MMC_RXIPV4_GD_FRMS_REG_OFFSET (0x210)
#define TMVH_LIPP6100ETH_MMC_RXIPV4_HDERR_FRMS_REG_OFFSET (0x214)

#define TMVH_LIPP6100ETH_MMC_RXIPV4_NOPAY_FRMS_REG_OFFSET (0x218)

#define TMVH_LIPP6100ETH_MMC_RXIPV4_FRAG_FRMS_REG_OFFSET (0x21C)

#define TMVH_LIPP6100ETH_MMC_RXIPV4_UDSBL_FRMS_REG_OFFSET (0x220)

#define TMVH_LIPP6100ETH_MMC_RXIPV6_GD_FRMS_REG_OFFSET (0x224)
#define TMVH_LIPP6100ETH_MMC_RXIPV6_HDERR_FRMS_REG_OFFSET (0x228)
#define TMVH_LIPP6100ETH_MMC_RXIPV6_NOPAY_FRMS_REG_OFFSET (0x22C)

#define TMVH_LIPP6100ETH_MMC_RXUDP_GD_FRMS_REG_OFFSET (0x230)
#define TMVH_LIPP6100ETH_MMC_RXUDP_ERR_FRMS_REG_OFFSET (0x234)

#define TMVH_LIPP6100ETH_MMC_RXTCP_GD_FRMS_REG_OFFSET (0x238)
#define TMVH_LIPP6100ETH_MMC_RXTCP_ERR_FRMS_REG_OFFSET (0x23C)

#define TMVH_LIPP6100ETH_MMC_RXICMP_GD_FRMS_REG_OFFSET (0x240)
#define TMVH_LIPP6100ETH_MMC_RXICMP_ERR_FRMS_REG_OFFSET (0x244)

/* 0x248 -- 0x24C reserved */

#define TMVH_LIPP6100ETH_MMC_RXIPV4_GD_OCTETS_REG_OFFSET (0x250)
#define TMVH_LIPP6100ETH_MMC_RXIPV4_HDRERR_OCTETS_REG_OFFSET (0x254)
#define TMVH_LIPP6100ETH_MMC_RXIPV4_NOPAY_OCTETS_REG_OFFSET (0x258)
#define TMVH_LIPP6100ETH_MMC_RXIPV4_FRAG_OCTETS_REG_OFFSET (0x25C)
#define TMVH_LIPP6100ETH_MMC_RXIPV4_UDSBL_OCTECTS_REG_OFFSET (0x260)

#define TMVH_LIPP6100ETH_MMC_RXIPV6_GD_OCTETS_REG_OFFSET (0x264)
#define TMVH_LIPP6100ETH_MMC_RXIPV6_HDRERR_OCTETS_REG_OFFSET (0x268)
#define TMVH_LIPP6100ETH_MMC_RXIPV6_NOPAY_OCTETS_REG_OFFSET (0x26C)

#define TMVH_LIPP6100ETH_MMC_RXUDP_GD_OCTETS_REG_OFFSET (0x270)
#define TMVH_LIPP6100ETH_MMC_RXUDP_ERR_OCTETS_REG_OFFSET (0x274)

#define TMVH_LIPP6100ETH_MMC_TCP_GD_OCTETS_REG_OFFSET (0x278)
#define TMVH_LIPP6100ETH_MMC_TCP_ERR_OCTETS_REG_OFFSET (0x27C)

#define TMVH_LIPP6100ETH_MMC_ICMP_GD_OCTETS_REG_OFFSET (0x280)
#define TMVH_LIPP6100ETH_MMC_ICMP_ERR_OCTETS_REG_OFFSET (0x284)
#endif

#if (TMFL_LIPP6100ETHSD_IEEE1588_TIMESTAMP || TMFL_SD_ALL)
/* IEEE 1588  Time stamp registers */
#define TMVH_LIPP6100ETH_TS_CTRL_ADDEND_UPDT_VAL (0x20U)
#define TMVH_LIPP6100ETH_TS_CTRL_ADDEND_UPDT_POS (5)

#define TMVH_LIPP6100ETH_TS_CTRL_INT_TRIG_VAL (0x10U)
#define TMVH_LIPP6100ETH_TS_CTRL_INT_TRIG_POS (4)

#define TMVH_LIPP6100ETH_TS_CTRL_TS_UPDATE_VAL (0x8U)
#define TMVH_LIPP6100ETH_TS_CTRL_TS_UPDATE_POS (3)

#define TMVH_LIPP6100ETH_TS_CTRL_TS_INIT_VAL (0x4U)
#define TMVH_LIPP6100ETH_TS_CTRL_TS_INIT_POS (2)

#define TMVH_LIPP6100ETH_TS_CTRL_FINE_UPDATE_VAL (0x2U)
#define TMVH_LIPP6100ETH_TS_CTRL_FINE_UPDATE_POS (1)

#define TMVH_LIPP6100ETH_TS_CTRL_TIMESTAMP_EN_VAL (0x1U)
#define TMVH_LIPP6100ETH_TS_CTRL_REG_OFFSET (0x700)

#define TMVH_LIPP6100ETH_TS_SUB_SECOND_INCR_REG_OFFSET (0x704)
#define TMVH_LIPP6100ETH_TS_HIGH_REG_OFFSET (0x708)
#define TMVH_LIPP6100ETH_TS_LOW_REG_OFFSET (0x70C)

#define TMVH_LIPP6100ETH_TS_HIGH_UPDATE_REG_OFFSET (0x710)

#define TMVH_LIPP6100ETH_TS_LOW_UPDATE_PSNT_VAL (0x80000000U)
#define TMVH_LIPP6100ETH_TS_LOW_UPDATE_REG_OFFSET (0x714)

#define TMVH_LIPP6100ETH_TS_ADDEND_REG_OFFSET (0x718)

#define TMVH_LIPP6100ETH_TS_TGT_TIME_HIGH_REG_OFFSET (0x71C)
#define TMVH_LIPP6100ETH_TS_TGT_TIME_LOW_REG_OFFSET (0x720)

#endif

/* Macro to compute perfect address filter register offset value */
#define TMVH_LIPP6100ETH_PERADRBLK1_OFFSET(_regnum_) (((_regnum_)-1)*8) 
#define TMVH_LIPP6100ETH_PERADRBLK2_OFFSET(_regnum_) (((_regnum_)-16)*8) 

/* Register Read Write Macro's  */

#ifndef TMVH_GEN_READ

#define TMVH_GEN_READ(_address_,_result_)                                          \
            (_result_) = *(volatile UInt32 *)(_address_)
#endif

#ifndef TMVH_GEN_WRITE

#define TMVH_GEN_WRITE(_address_,_value_)                                          \
           *(volatile UInt32 *)(_address_) = (_value_)

#endif

#ifdef __cplusplus
}
#endif

#endif 


