/*
 * (C) Copyright 2003
 * Wolfgang Denk, DENX Software Engineering, wd@denx.de.
 * (C) Copyright 2006
 * NXP Semiconductors,
 * Robert Delien robert.delien@nxp.com, Hans Zuidam hans.zuidam@nxp.com
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

/*
 * This file contains the configuration parameters for the Samsung TV522/32
 * Samsung board.  which is a TV52x series based platform
 */

#ifndef __CONFIG_H
#define __CONFIG_H

#define CONFIG_TV522_32_SAMSUNG
#define CONFIG_TV52X

#include <pnx8550_glb.h>

/* PNX853x have a 4KEc MIPS32 core */
#define CONFIG_MIPS32					/* MIPS32 CPU core */


/*-----------------------------------------------------------------------
 * Default environment variables
 */
#define CONFIG_BOOTCOMMAND	""
#define CONFIG_BOOTDELAY	5	/* autoboot after 5 seconds	*/
#define CONFIG_BAUDRATE		38400
#define CONFIG_BOOTFILE		/vmlinux		/* File to boot */
#define CONFIG_LOADADDR		0x82000000		/* SDRAM address to load files to */


#define CONFIG_TIMESTAMP		/* Print image info with timestamp */
#undef	CONFIG_BOOTARGS

#define CONFIG_EXTRA_ENV_SETTINGS					\
	"addmisc=setenv bootargs $(bootargs) "				\
		"console=ttyS0,$(baudrate) "				\
		"panic=1\0"						\
	""

/*
 * Define the commands supported
 */
#if defined(CONFIG_TV522_32_SAMSUNG_SMALL)

#define CONFIG_COMMANDS		( (CONFIG_CMD_DFL	|\
				   CFG_CMD_BSP		|\
				   CFG_CMD_EEPROM	|\
				   CFG_CMD_ELF		|\
				   CFG_CMD_NAND)	\
			         &			\
				 ~(CFG_CMD_BOOTD	|\
				   CFG_CMD_CONSOLE	|\
				   CFG_CMD_ENV		|\
				   CFG_CMD_FLASH	|\
				   CFG_CMD_FPGA		|\
				   CFG_CMD_IMI		|\
				   CFG_CMD_IMLS		|\
				   CFG_CMD_LOADS	|\
				   CFG_CMD_LOADB	|\
				   CFG_CMD_NET) )

#else

#define CONFIG_COMMANDS		( (CONFIG_CMD_DFL	|\
				   CFG_CMD_BSP		|\
				   CFG_CMD_CACHE	|\
				   CFG_CMD_EEPROM	|\
				   CFG_CMD_ELF		|\
				   CFG_CMD_FAT		|\
				   CFG_CMD_I2C		|\
				   CFG_CMD_NAND		|\
				   CFG_CMD_PCI		|\
				   CFG_CMD_JFFS2	|\
				   CFG_CMD_NET		|\
				   CFG_CMD_MII		|\
				   CFG_CMD_DHCP		|\
				   CFG_CMD_PING		|\
				   CFG_CMD_USB)		&\
				   ~(CFG_CMD_ENV | CFG_CMD_FLASH | CFG_CMD_IMLS) )

#endif

#include <cmd_confdefs.h> /* To be included AFTER the definition of CONFIG_COMMANDS */


/*-----------------------------------------------------------------------
 * NOR flash configuration
 */
#define CFG_NO_FLASH
#undef	CONFIG_CRAMFS		/* No CRAM FS support although JFFS2 support */


/*-----------------------------------------------------------------------
 * NAND flash configuration (Use legacy NAND flash support (for now))
 */
#define CFG_NAND_LEGACY
#define CFG_MAX_NAND_DEVICE	5		/* Max number of NAND devices		*/
#define CONFIG_MTD_NAND_VERIFY_WRITE
#define NAND_MAX_FLOORS 1
#define NAND_MAX_CHIPS 1
#define NAND_ChipID_UNKNOWN	0x00
#define SECTORSIZE		512
#define	CONFIG_JFFS2_CMDLINE	1
#define	CONFIG_JFFS2_DEV	"nand0"
#define	CONFIG_JFFS2_NAND
#define	MTDIDS_DEFAULT		"nand0=sys"
#define	MTDPARTS_DEFAULT	"mtdparts=sys:11232k@176k(bootfs);sys:4000k@11408k(rootfs)"



/*-----------------------------------------------------------------------
 * Miscellaneous configurable options
 */
#define CFG_LONGHELP				/* undef to save memory      */
#define CFG_PROMPT		"TV522/32 # "	/* Monitor Command Prompt    */
#define CFG_CBSIZE		256		/* Console I/O Buffer Size   */
#define CFG_PBSIZE		(CFG_CBSIZE + sizeof(CFG_PROMPT) + 16)	/* Print Buffer Size */
#define CFG_MAXARGS		16		/* max number of command args*/

#define CFG_MALLOC_LEN		256*1024

#define CFG_BOOTPARAMS_LEN	128*1024

#define CFG_CP0_COUNT_RATE	125000000	/* Half the CPU core frequency */
#define CFG_HZ			1000

/*-----------------------------------------------------------------------
 * Memory Map
 */
#include <asm/addrspace.h>
#define CFG_INIT_SP_OFFSET	0x00080000	/* Put initial stack at 512kiB	*/
#if !defined(CONFIG_TV522_32_SAMSUNG_SMALL)
#define CFG_SDRAM_BASE		KSEG1ADDR(SDRAM_BASE)	/* Uncached alias	*/
#else
#define CFG_SDRAM_BASE		KSEG0ADDR(SDRAM_BASE)	/* Cached alias		*/
#endif
#define CFG_SDRAM_MAX		SDRAM_MAX		/* 128MiB		*/

#define CFG_LOAD_ADDR		0x82000000	/* load address of zImage 	*/

#define CFG_MEMTEST_START	(CFG_SDRAM_BASE)
#define CFG_MEMTEST_END		((CFG_SDRAM_BASE)+(CFG_INIT_SP_OFFSET))

/*-----------------------------------------------------------------------
 * Serial port configuration
 */
#define CFG_IP0107_UART				/* Has an IP0107 on SoC		*/
#define CFG_IP0107_CLOCK	3692300		/* 3.6923 MHz			*/
#define CFG_CONSOLE_PORT	IP0107_1	/* Use UART 1 for console	*/
#define CFG_BAUDRATE_TABLE	{ 50, 75, 110, 134.5, 150, 300, 600, 1200, 2400, \
				  4800, 9600, 19200, 38400, 57600, 115200, 230400 }

/*-----------------------------------------------------------------------
 * Console configuration
 */
#define CFG_HUSH_PARSER				/* Enable HUSH shell parser	*/
#define CFG_PROMPT_HUSH_PS2	"> "		/* Configure HUSH sec. prompt	*/
#define CONFIG_CMDLINE_EDITING			/* Enable command line editing	*/


/* The following #defines are needed to get flash environment right */
#define CFG_MONITOR_BASE	TEXT_BASE
#define CFG_MONITOR_LEN		(192 << 10)	/* No more than 192KiB */


/*-----------------------------------------------------------------------
 * Environment configuration
 */
#define	CFG_ENV_IS_IN_EEPROM			/* Use AT24C256B	*/
#undef	CFG_ENV_IS_NOWHERE
#define	CFG_ENV_OFFSET			0x0000
#define	CFG_ENV_SIZE			256
#define	CFG_EEPROM_IS_AT24C256B		1       /*XXX Atmel AT24C256B	*/
#define	CFG_EEPROM_PAGE_WRITE_BITS	6       /* 64B pages		*/
#undef	CFG_EEPROM_PAGE_WRITE_DELAY_MS		/* Don't use this!	*/
#define	CFG_EEPROM_SIZE			32768   /* 256Kib = 32KiB	*/
#define	CFG_EEPROM_WREN			1	/* Need write-enable fn.*/
#define	CFG_I2C_EEPROM_ADDR		0x50    /* Atmel AT24C256B	*/
#define	CFG_I2C_EEPROM_ADDR_LEN		2       /* 32KiB is 2 bytes/addr*/
#undef	CFG_I2C_EEPROM_ADDR_OVERFLOW
#define	CFG_I2C_MULTI_EEPROMS		1       /* Multiple EEPROMs	*/


/*-----------------------------------------------------------------------
 * Cache Configuration
 */
#define CFG_DCACHE_SIZE		16384
#define CFG_ICACHE_SIZE		16384
#define CFG_CACHELINE_SIZE	32

/*-----------------------------------------------------------------------
 * PCI Configuration
 */
#define CONFIG_PCI
#define CONFIG_PCI_PNP
#define CONFIG_NXP_PCIXIO_IPA051


/*-----------------------------------------------------------------------
 * XIO Configuration
 */
#define CONFIG_XIO


/*-----------------------------------------------------------------------
 * USB Configuration
 */
#if !defined(CONFIG_TV522_32_SAMSUNG_SMALL)
#define CONFIG_PCI_OHCI
#define CONFIG_USB_OHCI_NEW
#define LITTLEENDIAN			1

#define CFG_DEVICE_DEREGISTER
#define CFG_USB_EVENT_POLL
#define CFG_USB_OHCI_SLOT_NAME 		"ohci_pci"
#define CFG_USB_OHCI_MAX_ROOT_PORTS	2

/* process single td's on done queue or process all td's from urb (up to
 * max number of defined td's) in the done queue at once */
#undef CFG_USB_OHCI_DQ_SINGLE_TD_PROCESSING


#define CONFIG_USB_STORAGE
#define CONFIG_DOS_PARTITION
/* usb network configuration settings
 */
#define CONFIG_NET_MULTI	/* needed for `eth_*' functions */
#define CONFIG_PEGASUS
#define CONFIG_MII
#endif


/*-----------------------------------------------------------------------
 * I2C Configuration
 */
#define CONFIG_NXP_I2C
#define CONFIG_NXP_I2C_IP0105
#define CONFIG_NXP_I2C_IP3203
#define CONFIG_HARD_I2C
#define CFG_I2C_SPEED			(150000)	/* 150kHz */
#define CFG_I2C_SLAVE			0
#define CONFIG_I2C_CMD_TREE
#define CONFIG_I2C_MULTI_BUS



/*-----------------------------------------------------------------------
 * Stand-by processor Configuration
 */
#define CONFIG_MISC_INIT_R
#define CONFIG_STANDBY_SLAVE_BUS	0x03
#define CONFIG_STANDBY_SLAVE_ADDR 	0x30

#endif	/* __CONFIG_H */
