/*
 * (C) Copyright 2003
 * Wolfgang Denk, DENX Software Engineering, wd@denx.de.
 * (C) Copyright 2006
 * NXP Semiconductors,
 * Robert Delien robert.delien@nxp.com, Hans Zuidam hans.zuidam@nxp.com
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

/*
 * This file contains the configuration parameters for the NXP
 * TV55x, which is a TV550 series based platform
 */

#ifndef __CONFIG_H
#define __CONFIG_H

#define CONFIG_TV52X
#define CONFIG_TV55X     /* for 55x specific settings */

#include <pnx8550_glb.h>

/* PNX855xx have a MIPS24KEf MIPS32 core */
#define CONFIG_MIPS32                   /* MIPS32 CPU core */

/* 
 *  Specify whether or not u-boot needs to relocate 
 */
#define  CONFIG_SKIP_RELOCATE_UBOOT

#define CONFIG_SYS_MTD_PARTITION_EXTERNAL

/*-----------------------------------------------------------------------
 * Timing related configuration
 */
#define CONFIG_SYS_MIPS_TIMER_FREQ  525000000
#define CONFIG_SYS_HZ               1000
#define CONFIG_CP0_COUNT_RATE       (CONFIG_SYS_MIPS_TIMER_FREQ/2)   /* Half the CPU core frequency */
/* TSU clock */
#define CONFIG_TSU_CLOCK            13500000    /* 13.5Mhz */

/*-----------------------------------------------------------------------
 * Default environment variables
 */


//#define CONFIG_BOOTCOMMAND          "bootp;go 0x60000"
//#define CONFIG_BOOTCOMMAND          "bootp;autoscr 0x01fec800"
#undef CONFIG_BOOTCOMMAND          

/*
Macro                                     |  Macro
Production                                |  Development
-----------------------------------------------------------------------------------------
#define CONFIG_BOOTDELAY            0     |  #define CONFIG_BOOTDELAY            2
#undef CONFIG_AUTOBOOT_STOP_STR           |  #define CONFIG_AUTOBOOT_STOP_STR    " "
#undef CONFIG_AUTOBOOT_STOP_STR2          |  #define CONFIG_AUTOBOOT_STOP_STR2   "\n"
#define CONFIG_DISABLE_COMMANDLINE  1     |  #undef CONFIG_DISABLE_COMMANDLINE
-----------------------------------------------------------------------------------------
*/

#ifdef CONFIG_TV55X_PROD
#define CONFIG_BOOTDELAY            0           
#undef  CONFIG_AUTOBOOT_STOP_STR    
#undef  CONFIG_AUTOBOOT_STOP_STR2   
#undef  CONFIG_AUTOBOOT_DELAY_STR 	
#define  CONFIG_DISABLE_COMMANDLINE
#else
#define CONFIG_BOOTDELAY            2           /* autoboot after 2 seconds */
#define CONFIG_AUTOBOOT_STOP_STR    " "
//#define CONFIG_AUTOBOOT_STOP_STR2   "\n"
#define CONFIG_AUTOBOOT_STOP_STR2   "\r"
#define CONFIG_AUTOBOOT_DELAY_STR "\r"
#undef  CONFIG_DISABLE_COMMANDLINE
#endif

#define CONFIG_AUTOBOOT_KEYED 1
#define CONFIG_BAUDRATE             115200
//#define CONFIG_BOOTFILE             /vmlinux    /* File to boot */
#define CONFIG_BOOTFILE NandFlash_UpgradeImage.mi
#define CONFIG_SYS_LOAD_ADDR        0x82000000  /* SDRAM address to load files to */
#define CONFIG_LOADADDR		0x01fdc800

#ifdef CONFIG_LIPP_6300ETH 

#define CONFIG_NETMASK		255.255.255.0
#define CONFIG_BOOTP_SERVERIP 192.168.15.1 
//define CONFIG_IPADDR		192.168.15.247
#define CONFIG_SERVERIP		165.114.37.212
//#define CONFIG_GATEWAYIP 192.168.15.1
//#define CONFIG_ETHADDR aa:bb:cc:dd:e0:f0
#define CONFIG_TIMESTAMP            /* Print image info with timestamp */
#define KERNEL_CMDLINE "console=ttyS0,115200n8 mem=48M root=/dev/nfs rw ip=dhcp nfsroot=134.27.224.44:/opt/embeddedalley/nxp_tv550/rootfs debug init=/sbin/init"   

#endif /* CONFIG_LIPP_6300ETH */

#define CONFIG_TIMESTAMP            /* Print image info with timestamp */
#undef  CONFIG_BOOTARGS

#define CONFIG_EXTRA_ENV_SETTINGS                   \
    "addmisc=setenv bootargs $(bootargs) "              \
        "console=ttyS0,$(baudrate) "                \
        "panic=1\0"                     \
    ""


/* Pre default no features are enabaled */
#undef  CONFIG_CMD_ASKENV       /* ask for env variable         */
#undef  CONFIG_CMD_AUTOSCRIPT   /* Autoscript Support           */
#undef  CONFIG_CMD_BDI          /* bdinfo                       */
#undef  CONFIG_CMD_BEDBUG       /* Include BedBug Debugger      */
#undef  CONFIG_CMD_BMP          /* BMP support                  */
#undef  CONFIG_CMD_BOOTD        /* bootd                        */
#undef  CONFIG_CMD_BSP          /* Board Specific functions     */
#undef  CONFIG_CMD_CACHE	    /* icache, dcache		        */
#undef  CONFIG_CMD_CDP          /* Cisco Discovery Protocol     */
#undef  CONFIG_CMD_CONSOLE      /* coninfo                      */
#undef  CONFIG_CMD_DATE		    /* support for RTC, date/time...*/
#undef  CONFIG_CMD_DHCP         /* DHCP Support                 */
#undef  CONFIG_CMD_DIAG         /* Diagnostics                  */
#undef  CONFIG_CMD_DISPLAY      /* Display support              */
#undef  CONFIG_CMD_DOC          /* Disk-On-Chip Support         */
#undef  CONFIG_CMD_DTT          /* Digital Therm and Thermostat */
#undef  CONFIG_CMD_ECHO         /* echo arguments               */
#undef  CONFIG_CMD_EEPROM       /* EEPROM read/write support    */
#undef  CONFIG_CMD_NVRD         /* NVM read support             */
#undef  CONFIG_CMD_NVWR         /* NVM write support            */
#undef  CONFIG_CMD_SIGNAL_GPIO  /* <signal xx> / <setgpio xx xx> to sby */
#undef  CONFIG_CMD_ELF          /* ELF (VxWorks) load/boot cmd  */
#undef  CONFIG_CMD_ENV          /* saveenv                      */
#undef  CONFIG_CMD_EXT2         /* EXT2 Support                 */
#undef  CONFIG_CMD_FAT          /* FAT support                  */
#undef  CONFIG_CMD_FDC          /* Floppy Disk Support          */
#undef  CONFIG_CMD_FDOS         /* Floppy DOS support           */
#undef  CONFIG_CMD_FLASH        /* flinfo, erase, protect       */
#undef  CONFIG_CMD_FPGA         /* FPGA configuration Support   */
#undef  CONFIG_CMD_HWFLOW       /* RTS/CTS hw flow control      */
#undef  CONFIG_CMD_I2C          /* I2C serial bus support       */
#undef  CONFIG_CMD_IDE          /* IDE harddisk support         */
#undef  CONFIG_CMD_IMI          /* iminfo                       */
#undef  CONFIG_CMD_IMLS         /* List all found images        */
#undef  CONFIG_CMD_IMMAP        /* IMMR dump support            */
#undef  CONFIG_CMD_IRQ          /* irqinfo                      */
#undef  CONFIG_CMD_ITEST        /* Integer (and string) test    */
#undef  CONFIG_CMD_JFFS2        /* JFFS2 Support                */
#undef  CONFIG_CMD_KGDB         /* kgdb                         */
#undef  CONFIG_CMD_LOADB        /* loadb                        */
#undef  CONFIG_CMD_LOADS        /* loads                        */
#undef  CONFIG_CMD_MEMORY       /* md mm nm mw cp cmp crc base loop mtest */
#undef  CONFIG_CMD_MFSL         /* FSL support for Microblaze   */
#undef  CONFIG_CMD_MII          /* MII support                  */
#undef  CONFIG_CMD_MISC         /* Misc functions like sleep etc*/
#undef  CONFIG_CMD_MMC          /* MMC support                  */
#undef  CONFIG_CMD_MTDPARTS     /* Partition support            */
#undef  CONFIG_CMD_NAND         /* NAND support                 */
#undef  CONFIG_CMD_NET          /* bootp, tftpboot, rarpboot    */
#undef  CONFIG_CMD_NFS          /* NFS support                  */
#undef  CONFIG_CMD_ONENAND      /* OneNAND support              */
#undef  CONFIG_CMD_PCI          /* pciinfo                      */
#undef  CONFIG_CMD_PCMCIA       /* PCMCIA support               */
#undef  CONFIG_CMD_PING         /* ping support                 */
#undef  CONFIG_CMD_PORTIO       /* Port I/O                     */
#undef  CONFIG_CMD_REGINFO      /* Register dump                */
#undef  CONFIG_CMD_REISER       /* Reiserfs support             */
#undef  CONFIG_CMD_RUN          /* run command in env variable  */
#undef  CONFIG_CMD_SARI         /* Simple arithmetic operations */
#undef  CONFIG_CMD_SAVES        /* save S record dump           */
#undef  CONFIG_CMD_SCSI         /* SCSI Support                 */
#undef  CONFIG_CMD_SDRAM        /* SDRAM DIMM SPD info printout */
#undef  CONFIG_CMD_SETGETDCR    /* DCR support on 4xx           */
#undef  CONFIG_CMD_SNTP         /* SNTP support                 */
#undef  CONFIG_CMD_SPI          /* SPI utility                  */
#undef  CONFIG_CMD_TERMINAL     /* built-in Serial Terminal     */
#undef  CONFIG_CMD_UNIVERSE     /* Tundra Universe Support      */
#undef  CONFIG_CMD_UBI          /* UBI support                  */
#undef  CONFIG_CMD_UBIFS        /* UBI support                  */
#undef  CONFIG_CMD_USB          /* USB Support                  */
#undef  CONFIG_CMD_VFD          /* VFD support (TRAB)           */
#undef  CONFIG_CMD_XIMG         /* Load part of Multi Image     */
#undef  CONFIG_CMD_AT91_SPIMUX  /* AT91 MMC/SPI Mux Support     */

/*
 * Define the commands supported
 */
#if defined(CONFIG_TV55X_SMALL)
    #define CONFIG_CMD_ECHO         /* echo arguments               */
    #define CONFIG_CMD_ENV          /* saveenv                      */
    #define CONFIG_CMD_FAT          /* FAT support                  */
    #define CONFIG_CMD_I2C          /* I2C serial bus support       */
    #define CONFIG_CMD_MEMORY       /* md mm nm mw cp cmp crc base loop mtest */
    #define CONFIG_CMD_MISC         /* Misc functions like sleep etc*/
    #define CONFIG_CMD_MTDPARTS     /* Partition support            */
    #define CONFIG_CMD_NAND         /* NAND support                 */
    #define CONFIG_CMD_PCI          /* pciinfo                      */
    #define CONFIG_CMD_PORTIO       /* Port I/O                     */
    #define CONFIG_CMD_RUN          /* run command in env variable  */
    #define CONFIG_CMD_SARI         /* Simple arithmetic operations */
    #define CONFIG_CMD_UBI          /* UBI support                  */
#else
	/***********************************************************/
	/* Supported commands in production and development U-Boot */
	/***********************************************************/
    #define CONFIG_CMD_AUTOSCRIPT   /* Autoscript Support           */
	#define CONFIG_CMD_DISPLAY      /* splash                       */
    #define CONFIG_CMD_ECHO         /* echo arguments               */
	#define CONFIG_CMD_ENV          /* setenv/printenv but not saveenv */
    #define CONFIG_CMD_FAT          /* FAT support                  */
    #define CONFIG_CMD_I2C          /* I2C serial bus support       */
	#define CONFIG_CMD_MEMORY       /* md mm nm mw cp cmp crc base  */
	                                /* loop mtest                   */
    #define CONFIG_CMD_MISC         /* Misc functions like sleep etc*/
    #define CONFIG_CMD_MTDPARTS     /* Partition support            */
    #define CONFIG_CMD_NAND         /* NAND support                 */
    #define CONFIG_CMD_PCI          /* pciinfo                      */
     #define CONFIG_CMD_PORTIO       /* Port I/O                     */
    #define CONFIG_CMD_RUN          /* run command in env variable  */
    #define CONFIG_CMD_SARI         /* Simple arithmetic operations */
    #define CONFIG_CMD_UBI          /* UBI support                  */
	#define CONFIG_CMD_SIGNAL_GPIO  /* <signal xx> / <setgpio xx xx> to sby */
	#define CONFIG_CMD_SETEXPR      /* setexpr                      */
	#define CONFIG_CMD_JFFS2        /* JFFS2 Support                */

	#ifndef CONFIG_TV55X_PROD
	/***********************************************************/
	/* Additionally supported commands in development U-Boot   */
	/***********************************************************/
	#define CONFIG_CMD_SAVEENV      /* saveenv                      */
	#define CONFIG_CMD_DHCP         /* DHCP Support                 */
	#define CONFIG_CMD_LOADB        /* loadb                        */
	#define CONFIG_CMD_MII          /* MII support                  */
	#define CONFIG_CMD_NET          /* bootp, tftpboot, rarpboot    */
	#define CONFIG_CMD_NFS          /* NFS support                  */
	#define CONFIG_CMD_PING         /* ping support                 */
    #define CONFIG_CMD_USB          /* USB Support                  */
     #define CONFIG_CMD_NVRD         /* NVM read support             */
    #define CONFIG_CMD_NVWR         /* NVM write support            */
	#define CONFIG_LOOPW            /* Loop Write command only active */
	                                /* if CONFIG_CMD_MEM set          */
				                    /* Macro is CONFIG_LOOPW not CONFIG_CMD_LOOPW */
	#endif
#endif

/*-----------------------------------------------------------------------
 * FAT filesystem support
 */

#define CONFIG_SUPPORT_VFAT

#define CONFIG_SYS_SCSI_MAX_SCSI_ID 4
#define CONFIG_SYS_SCSI_MAX_LUN     4


/*-----------------------------------------------------------------------
 * 
 * Ethernet suppotr
 *  Natsemi support
 *  USB ethernet dongle
 */
#ifdef CONFIG_CMD_NET

#define CONFIG_NATSEMI
/* needed for `eth_*' functions */
#define CONFIG_NET_MULTI    
#define CONFIG_PEGASUS
#undef  CONFIG_MII
#define CONFIG_BOOTP_SUBNETMASK
#define CONFIG_BOOTP_GATEWAY
#define CONFIG_BOOTP_DNS

/* pnx85500 on board ethernet */
#ifdef CONFIG_LIPP_6300ETH

    #ifndef CONFIG_CMD_PING
    #define CONFIG_CMD_PING
    #endif

    /* For national dp83848 phy */
    #ifdef CONFIG_USING_DP83848_PHY
        #define TMFL_LIPP6100ETH_GMII_PHY_ADDRESS_VAL 0x1U 
        #define __USING_DP83848_PHY__
    #endif

    /* For smsc 8700 ethernet phy */
    #ifdef CONFIG_USING_SMSC8700_PHY
        #define TMFL_LIPP6100ETH_GMII_PHY_ADDRESS_VAL 0x16U 
        #define __USING_SMSC8700_PHY__
    #endif

    /* For smsc 8710 ethernet phy */
    #ifdef CONFIG_USING_SMSC8710_PHY
        #define TMFL_LIPP6100ETH_GMII_PHY_ADDRESS_VAL 0x0U 
        #define __USING_SMSC8710_PHY__
    #endif

    #ifdef CONFIG_PNX85500_M0_SOC    
        #define TMFL_LIPP6100ETH_GMII_ADDRESS_CSR_VAL 0x1U 
    #endif

    #ifdef CONFIG_PNX85500_M1_SOC    
        #define TMFL_LIPP6100ETH_GMII_ADDRESS_CSR_VAL 0x0U 
    #endif

#endif /* CONFIG_LIPP_6300ETH */


#endif /* #ifdef CONFIG_CMD_NET */

/*-----------------------------------------------------------------------
 * NOR flash configuration
 */
#define CONFIG_SYS_NO_FLASH
#undef  CONFIG_CRAMFS       /* No CRAM FS support although JFFS2 support */


/*-----------------------------------------------------------------------
 * NAND flash configuration 
 */

#define CONFIG_SYS_FLASH_BASE           0        

#undef  CONFIG_NAND_LEGACY
#undef  CONFIG_NAND
#undef  CONFIG_NAND_NXP_IPA051

#define CONFIG_NX_MEMCPY

#if defined(CONFIG_CMD_NAND)
//#define CONFIG_NAND_PERF_MEAS
#define CONFIG_DMAC_NXP_1902
#define CONFIG_NAND_NXP_2070
#undef CONFIG_NUMONYX_70NM_CACHEREAD_PATCH
#define CONFIG_MTD_NX_NAND_HWECC

/* TV550 M1B patch - to workaround nand init problem */
#undef CONFIG_TV55x_M1B_NAND_PATCH

#endif

#define CONFIG_SYS_ONENAND_BASE         0x1BC60000

#if defined(CFG_ONENAND)
/* Undef NAND if OneNAND enabled */
#undef CONFIG_CMD_NAND
#undef CONFIG_NAND_NXP_2070
#undef CONFIG_NUMONYX_70NM_CACHEREAD_PATCH
#undef CONFIG_MTD_NX_NAND_HWECC
#undef CONFIG_TV55x_M1B_NAND_PATCH

#define CONFIG_CMD_ONENAND
#define CONFIG_DMAC_NXP_1902
#define CONFIG_MTD_NX_ONENAND
#endif

#define CONFIG_SYS_MAX_NAND_DEVICE      1       /* Max number of NAND devices       */
#define CONFIG_SYS_NAND_QUIET           1

/* Note: NAND_BASE refers to the xio profiles, in board_nand_init the correct base 
   values are retreived from the xio profiles
*/
#define CONFIG_SYS_NAND_BASE            0x814, 0x818, 0x81C, 0x834, 0x838
#define CONFIG_MTD_NAND_VERIFY_WRITE
#define NAND_MAX_FLOORS                 1
#define NAND_MAX_CHIPS                  1
#define NAND_ChipID_UNKNOWN             0x00
#define SECTORSIZE                      512

#define CONFIG_LZO

/* UBIFS support */
#ifdef CONFIG_CMD_UBIFS
#define CONFIG_SYS_64BIT_VSPRINTF
//#define CONFIG_LZO
#endif

#define CONFIG_MTD_UBI_DEBUG
#define CONFIG_MTD_UBI_DEBUG_MSG
#define CONFIG_MTD_UBI_DEBUG_MSG_IO

#ifdef CONFIG_CMD_UBI
#define CONFIG_MTD_PARTITIONS
#define CONFIG_RBTREE
#define CONFIG_DOS_PARTITION
#else
#undef  CONFIG_MTD_PARTITIONS
#undef  CONFIG_RBTREE
#endif

/* JFFS2 support */
#ifdef CONFIG_CMD_MTDPARTS
#define CONFIG_JFFS2_CMDLINE            1
#define CONFIG_JFFS2_DEV                "nand0"
#define CONFIG_JFFS2_NAND
#undef MTDIDS_DEFAULT
#undef MTDPARTS_DEFAULT
#endif

/*-----------------------------------------------------------------------
 * Miscellaneous configurable options
 */
//#if !defined(CONFIG_TV55X_SMALL)
//#define CONFIG_SYS_LONGHELP                         /* undef to save memory      */
//#endif
#undef CONFIG_SYS_LONGHELP                         /* undef to save memory      */

#if defined(CONFIG_TV55X_SMALL)
#undef  CONFIG_AUTO_COMPLETE
#undef  CONFIG_MEM_CONSOLE
#endif

#define CONFIG_SYS_PROMPT               "TV55x # "  /* Monitor Command Prompt    */
#define CONFIG_SYS_CBSIZE               1024         /* Console I/O Buffer Size   */
#define CONFIG_SYS_PBSIZE               (CONFIG_SYS_CBSIZE + sizeof(CONFIG_SYS_PROMPT) + 16)    /* Print Buffer Size */
#define CONFIG_SYS_MAXARGS              32          /* max number of command args*/

//#define CONFIG_SYS_MALLOC_LEN           (2*1024*1024)
//YW: 4MB will overlap with nfs kernel
#define CONFIG_SYS_MALLOC_LEN           (3*1024*1024)

#define CONFIG_SYS_BOOTPARAMS_LEN       (8*1024)

/* during mmio scan, invalid module ids could be encountered */
#define CFG_MMIO_WARN_INV_MODID_COUNT           /* ..just count and warn user */
#define CFG_MMIO_WARN_INV_MODID_RANGES          /* ..just display range and warn user */


#if !defined(CONFIG_TV55X_SMALL)
/* Upgrader configuration */
//#define CONFIG_TV52X_UPGRADE
//#define CONFIG_BOOTDELAY_UPGRADER 0
#undef CONFIG_TV52X_UPGRADE
#undef CONFIG_BOOTDELAY_UPGRADER
#endif

/*For detetcing I2c modules */
#define CONFIG_TV55X_I2C_PATCH

/*-----------------------------------------------------------------------
 * Memory Map
 */
#include <asm/addrspace.h>
#define CONFIG_SYS_INIT_SP_OFFSET       0x000D0000  /* Put initial stack at 512kiB  */
#define CONFIG_SYS_SDRAM_BASE           KSEG0ADDR(SDRAM_BASE)   /* Cached alias     */
//#define CFG_SDRAM_MAX                   SDRAM_MAX       /* 256 MiB       */

#define CONFIG_SYS_MEMTEST_START        (CONFIG_SYS_SDRAM_BASE)
#define CONFIG_SYS_MEMTEST_END          ((CONFIG_SYS_SDRAM_BASE)+(CONFIG_SYS_INIT_SP_OFFSET))

/*-----------------------------------------------------------------------
 * Serial port configuration
 */
#define CFG_IP0107_UART                 /* Has an IP0107 on SoC     */
#define CFG_IP0107_CLOCK                3692300     /* 3.6923 MHz           */
#ifndef CFG_CONSOLE_PORT
#define CFG_CONSOLE_PORT                IP0107_1    /* Use UART 1 for console   */
#endif
#define CONFIG_SYS_BAUDRATE_TABLE       { 50, 75, 110, 134.5, 150, 300, 600, 1200, 2400, \
                                        4800, 9600, 19200, 38400, 57600, 115200, 230400 }

/*-----------------------------------------------------------------------
 * Console configuration
 */
#define CONFIG_SYS_HUSH_PARSER                  /* Enable HUSH shell parser */
#define CONFIG_SYS_PROMPT_HUSH_PS2      "> "    /* Configure HUSH sec. prompt   */
#define CONFIG_CMDLINE_EDITING                  /* Enable command line editing  */


/* The following #defines are needed to get flash environment right */
#define CONFIG_SYS_MONITOR_BASE         TEXT_BASE
#define CFG_MONITOR_LEN                 (192 << 10) /* No more than 192KiB */


/*-----------------------------------------------------------------------
 * Environment configuration
 */
#define  CONFIG_ENV_IS_NOWHERE

#define CONFIG_ENV_OVERWRITE
//#define CONFIG_DYN_ENV

#if defined(CONFIG_CMD_NAND)
#undef CONFIG_ENV_IS_NOWHERE
#define CONFIG_ENV_IS_IN_NAND

// Get env offset from partition table
#undef  CONFIG_ENV_OFFSET				
#define CONFIG_ENV_OFFSET_REDUND		
#endif

#define CONFIG_ENV_OVERWRITE

#if defined(CFG_ONENAND)
#undef  CONFIG_ENV_IS_NOWHERE
#define CONFIG_ENV_IS_IN_ONENAND
#define CONFIG_ENV_ADDR                 0x00120000

// Get env offset from partition table
#undef CONFIG_ENV_OFFSET				
#define CONFIG_ENV_OFFSET_REDUND		
#endif

// Same for SP/LP nand flash
#define CONFIG_ENV_SIZE         		0x00004000  /* Size of Environment Sector   */

// Dyn env var:
// max 32 entries, length: 512Bytes
#define CONFIG_MAX_ENVVARS			32
#define CONFIG_SIZE_ALLOWED_VARS	512

/*-----------------------------------------------------------------------
 * Cache Configuration
 */
#define CONFIG_SYS_DCACHE_SIZE          16384
#define CONFIG_SYS_ICACHE_SIZE          16384
#define CONFIG_SYS_CACHELINE_SIZE       32

/*-----------------------------------------------------------------------
 * PCI Configuration
 */
#if !defined(CONFIG_TV55X_SMALL)
#undef CONFIG_PCI
#undef  CONFIG_PCI_PNP
#endif
#undef CONFIG_NXP_PCIXIO_IPA051 /*HZ*/

/*-----------------------------------------------------------------------
 * XIO Configuration
 */
#define CONFIG_XIO /*HZ*/


/*-----------------------------------------------------------------------
 * USB Configuration
 */
#define LITTLEENDIAN                        1

#if !defined(CONFIG_TV55X_SMALL) && !defined(CONFIG_TV55X_PROD)
// ip90.. is not a PCI device
#define CONFIG_EHCI_HCD_INIT_AFTER_RESET
#define CONFIG_USB_EHCI
#define CONFIG_USB_EHCI_NXP
#define CONFIG_SYS_USB_EHCI_MAX_ROOT_PORTS  8
#define CONFIG_SYS_IMMR                     IP9028
#define CONFIG_SYS_USB_EHCI_REGS_BASE       IP9028
#define CONFIG_EHCI_DCACHE

#undef  CONFIG_PCI_OHCI
#undef  CONFIG_USB_OHCI_NEW
#define CONFIG_SYS_USB_OHCI_REGS_BASE       IP9028

#define CFG_DEVICE_DEREGISTER
#define CFG_USB_EVENT_POLL
#define CONFIG_SYS_USB_OHCI_SLOT_NAME       "ohci_pci"
#define CONFIG_SYS_USB_OHCI_MAX_ROOT_PORTS  8

/* process single td's on done queue or process all td's from urb (up to
 * max number of defined td's) in the done queue at once */
#undef CFG_USB_OHCI_DQ_SINGLE_TD_PROCESSING

#define CONFIG_USB_STORAGE
#define CONFIG_DOS_PARTITION

#define CONFIG_USB_NETWORK

#endif


/*-----------------------------------------------------------------------
 * I2C Configuration
 */
#define CONFIG_NXP_I2C
#undef  CONFIG_NXP_I2C_IP0105
#define CONFIG_NXP_I2C_IP3203
#define CONFIG_HARD_I2C
#define CONFIG_SYS_I2C_SPEED                (150000)    /* 150kHz */
#define CONFIG_SYS_I2C_SLAVE                0
#define CONFIG_I2C_CMD_TREE
#define CONFIG_I2C_MULTI_BUS

#define CONFIG_SYS_I2C_EEPROM_ADDR_LEN      2
//#define CFG_I2C_MULTI_EEPROMS       //YW: replaced by  CONFIG_SYS_I2C_MULTI_EEPROMS
//#define CONFIG_SYS_I2C_MULTI_EEPROMS


/*-----------------------------------------------------------------------
 * Stand-by processor Configuration
 */
#define CONFIG_MISC_INIT_R
#define CONFIG_STANDBY_SLAVE_BUS            0x00
#define CONFIG_STANDBY_SLAVE_ADDR           0x30

/*-----------------------------------------------------------------------
 * NVM Configuration
 */
#define CONFIG_NVM_SLAVE_BUS            	0x00
#define CONFIG_NVM_SLAVE_ADDR           	0x57
#define CONFIG_NVM_SIZE			        8192


/*-----------------------------------------------------------------------
 * Secure boot configuration
 */
#define CONFIG_SECURE_BOOT
#ifdef CONFIG_SECURE_BOOT
#define CONFIG_USE_FAT_FS
#undef  CONFIG_USB_SHOW_PROGRESS

/* This flag indicates that we authenticate env bin.
 * Only switch off for development!
 */
#define CONFIG_AUTH_ENV_BIN
#define CONFIG_SIG_SIZE						0x100
#else
#define CONFIG_USB_SHOW_PROGRESS
#endif

/* 
  * Misc
  */
 #define CONFIG_NUM_OF_SCRATCH_REGS         32
//#define CONFIG_CMD_SETEXPR
//#define CONFIG_CMD_LOOPW

// The default bootcmd. Used if the intended bootcmdxxx is not found
#define CONFIG_DEFAULT_BOOTCMD "bootcmd"
// At this moment, tlb mapping is only done in FSBL. 
// Add this flag for starting with ejtag
#define CONFIG_TLB_MAPPING 
#define CONFIG_PATCH_PCL_BOARD
#endif  /* __CONFIG_H */

