/*
 * Device driver for OneNAND flash connected IP_2070 ESMC.
 *
 * Copyright (C) 2008 NXP B.V.
 * All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Revision history
 * Version    Author           Date          Remarks
 * 0.0.1    Bangaragiri G     20090315    Draft-Initial version
 */

/* Register definitions */
#define  ONENAND_CFG_ENA   	(1 << 9)
#define  ONENAND_ADDR_MSB_POS   (11)
#define  ONENAND_ADDR_MSB_BIT   (1 << 17)
#define  ONENNAND_ADDR_128KB    (0x0001FFFF)

#define  ONENAND_2016_AHB_SIZE 			(0x40000000)
#define  GLB_MISC2_ONENAND_SLOT_POS (6)

#define PNX8XXX_IP2016_BASE_VIRT (MMIO_BASE + 0x0002A000)
#define PNX8XXX_DEV_CFG_OFFSET   (0x020)

#define PNX8XXX_IP2016_MAIN_CFG  (0x000)
#define PNX8XXX_IP2016_READ_CFG  (0x004)
#define PNX8XXX_IP2016_BURST_CFG (0x00C)

#define ONENAND_SYNC_SYS_CFG1    (0xC080)

#define PNX8XXX_SYNC_MAIN_CFG    (0x00000011)
#define PNX8XXX_SYNC_READ_CFG    (0x00000004)
#define PNX8XXX_SYNC_BURST_CFG   (0x00000083)

/*
 * OneNAND control structure
 */
struct nx_onenand_ctrl {
	struct mtd_info       	*mtd;              	/* MTD information structure */
	struct onenand_chip   	*chip;             	/* OneNAND chip structure */
	uint32_t		onenand_base_phys;	/* OneNAND AHB map phys address */
	void __iomem    	*glb_misc2;	      	/* MISC2 register */
	uint8_t               	*dmabuf;		/* DMA buffer */
	uint8_t               	*dmabuf_unalgn;		/* Unaligned buffer */
	uint32_t		ahb_base;         	/* AHB base address for DMAC */
	void __iomem    	*main_cfg;	    	/* IP_2016 MAIN_CFG register */
	void __iomem    	*read_cfg;	    	/* IP_2016 READ register */
	void __iomem    	*burst_cfg;	    	/* IP_2016 BURST_CFG register */
	uint32_t		main_async_val;   	/* MAIN CFG reg value for async */
	uint32_t		read_async_val;   	/* READ CFG reg value for async */
	uint32_t		burst_async_val;  	/* BUSRT CFG reg value for async */
	uint16_t		sys_cfg1_val;  		/* SYS CFG1 reg value for async */
};

