/*
 * (C) Copyright 2006
 * NXP Semiconductors,
 * Robert Delien robert.delien@nxp.com, Hans Zuidam hans.zuidam@nxp.com
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 *
 */

#ifndef NXP_GLOBAL1_IP0126_H
#define NXP_GLOBAL1_IP0126_H

/*
 * Register address definitions
 */
#define IP0126_MIPS_RESET_VEC      		(IP0126 + 0x010)

#define IP0126_MIPS_RESET_VEC_MTL_SHIFT		(4)
#define IP0126_MIPS_RESET_VEC_MTL_MASK     	(0x1F0)

#define IP0126_MIPS_RESET_VECTOR   		(IP0126 + 0x10 ) 	
#define IP0126_SYS_ENDIANNESS 	 		(IP0126 + 0x14 )	
#define IP0126_DMA_GATE_LO 	 		(IP0126 + 0x200) 	
#define IP0126_DMA_GATE_HI 	 		(IP0126 + 0x204) 	
#define IP0126_APERTURE_WE 	 		(IP0126 + 0x208) 	
#define IP0126_ETHERNET_CONFIG 			(IP0126 + 0x220) 	
#define IP0126_MIPS24KE_CONFIG 			(IP0126 + 0x230) 	
#define IP0126_BASE14_MMIO 	 		(IP0126 + 0x240) 	
#define IP0126_BASE14_DVBT_MMIO 		(IP0126 + 0x244) 	
#define IP0126_DVB_T_DEBUG_CONTROL 		(IP0126 + 0x250) 	
#define IP0126_TS_MULTIPLEX_CONTROL 		(IP0126 + 0x260) 	
#define IP0126_BIS_BASE_ADDR 	 		(IP0126 + 0x270) 	
#define IP0126_AUDIO_IO1 	 		(IP0126 + 0x300) 	
#define IP0126_AUDIO_IO2 	 		(IP0126 + 0x304) 	
#define IP0126_GLBREG_MISC1 	 		(IP0126 + 0x308) 	
#define IP0126_IO_CTRL1 	 		(IP0126 + 0x400) 	
#define IP0126_PCI_CTRL 	 		(IP0126 + 0x404) 	
#define IP0126_VIDEO_CTRL 	 		(IP0126 + 0x408) 	
#define IP0126_AUDIO_CTRL 	 		(IP0126 + 0x40c) 	
#define IP0126_TSTAMP_CTRL 	 		(IP0126 + 0x410) 	
#define IP0126_IO_CTRL3 	 		(IP0126 + 0x418) 	
#define IP0126_IIC_SLAVE_ADDR 	 		(IP0126 + 0x41c) 	
#define IP0126_POWER_DOWN_CTRL 			(IP0126 + 0x420) 	
#define IP0126_GPIO_MUX_SEL 	 		(IP0126 + 0x424) 	
#define IP0126_SCRATCH0 	 		(IP0126 + 0x500) 	
#define IP0126_SCRATCH1 	 		(IP0126 + 0x504) 	
#define IP0126_SCRATCH2 	 		(IP0126 + 0x508) 	
#define IP0126_SCRATCH3 	 		(IP0126 + 0x50c) 	
#define IP0126_SCRATCH4 	 		(IP0126 + 0x510) 	
#define IP0126_SCRATCH5 	 		(IP0126 + 0x514) 	
#define IP0126_SCRATCH6 	 		(IP0126 + 0x518) 	
#define IP0126_SCRATCH7 	 		(IP0126 + 0x51c) 	
#define IP0126_SCRATCH8 	 		(IP0126 + 0x520) 	
#define IP0126_SCRATCH9 	 		(IP0126 + 0x524) 	
#define IP0126_SCRATCH10 	 		(IP0126 + 0x528) 	
#define IP0126_SCRATCH11 	 		(IP0126 + 0x52c) 	
#define IP0126_SCRATCH12 	 		(IP0126 + 0x530) 	
#define IP0126_SCRATCH13 	 		(IP0126 + 0x534) 	
#define IP0126_SCRATCH14 	 		(IP0126 + 0x538) 	
#define IP0126_SCRATCH15 	 		(IP0126 + 0x53c) 	
#define IP0126_SCRATCH16 	 		(IP0126 + 0x540) 	
#define IP0126_SCRATCH17 	 		(IP0126 + 0x544) 	
#define IP0126_SCRATCH18 	 		(IP0126 + 0x548) 	
#define IP0126_SCRATCH19 	 		(IP0126 + 0x54c) 	
#define IP0126_SCRATCH20 	 		(IP0126 + 0x550) 	
#define IP0126_SCRATCH21 	 		(IP0126 + 0x554) 	
#define IP0126_SCRATCH22 	 		(IP0126 + 0x558) 	
#define IP0126_SCRATCH23 	 		(IP0126 + 0x55c) 	
#define IP0126_SCRATCH24 	 		(IP0126 + 0x560) 	
#define IP0126_SCRATCH25 	 		(IP0126 + 0x564) 	
#define IP0126_SCRATCH26 	 		(IP0126 + 0x568) 	
#define IP0126_SCRATCH27 	 		(IP0126 + 0x56c) 	
#define IP0126_SCRATCH28 	 		(IP0126 + 0x570) 	
#define IP0126_SCRATCH29 	 		(IP0126 + 0x574) 	
#define IP0126_SCRATCH30 	 		(IP0126 + 0x578) 	
#define IP0126_SCRATCH31 	 		(IP0126 + 0x57c) 	
#define IP0126_GLBREG_MISC2 	 		(IP0126 + 0x600) 	
#define IP0126_GLBREG_MISC3 	 		(IP0126 + 0x604) 	
#define IP0126_GLBREG_MISC4 	 		(IP0126 + 0x608) 	
#define IP0126_USB_CTRL 	 		(IP0126 + 0x60c) 	
#define IP0126_AVDSP_TM_PWRDWN_CONTROL 		(IP0126 + 0x700) 	
#define IP0126_AVDSP_TM_PWRDWN_STATUS 	 	(IP0126 + 0x704) 	
#define IP0126_AVDSP_TM_MISC 	 	 	(IP0126 + 0x708) 	
#define IP0126_AVDSP_TM_OBSERVE 		(IP0126 + 0x70c) 	
#define IP0126_MSVD_TM_PWRDWN_CTRL 	 	(IP0126 + 0x720) 	
#define IP0126_MSVD_TM_PWRDWN_STATUS 		(IP0126 + 0x724) 	
#define IP0126_MSVD_TM_MISC 	 		(IP0126 + 0x728) 	
#define IP0126_MSVD_TM_OBSERVE 			(IP0126 + 0x72c) 	
#define IP0126_MSVD_TM_MMIO 	 		(IP0126 + 0x730) 	
#define IP0126_NM1_TM_PWRDWN_CTRL 	 	(IP0126 + 0x740) 	
#define IP0126_NM1_TM_PWRDWN_STATUS 		(IP0126 + 0x744) 	
#define IP0126_NM1_TM_MISC 	 	 	(IP0126 + 0x748) 	
#define IP0126_NM1_TM_OBSERVE 	READONLY 	(IP0126 + 0x74c) 	
#define IP0126_NM2_TM_PWRDWN_CTRL 	 	(IP0126 + 0x760) 	
#define IP0126_NM2_TM_PWRDWN_STATUS 		(IP0126 + 0x764) 	
#define IP0126_NM2_TM_MISC 	 	 	(IP0126 + 0x768) 	
#define IP0126_NM2_TM_OBSERVE 	READONLY	(IP0126 + 0x76c) 	
#define IP0126_NM_COPROC_PWRDWN_CTRL 	 	(IP0126 + 0x770) 	
#define IP0126_NM_COPROC_PWRDWN_STATUS 		(IP0126 + 0x774) 	
#define IP0126_SEMAPHORE0 	 		(IP0126 + 0x800) 	
#define IP0126_SEMAPHORE1 	 		(IP0126 + 0x804) 	
#define IP0126_SEMAPHORE2 	 		(IP0126 + 0x808) 	
#define IP0126_SEMAPHORE3 	 		(IP0126 + 0x80c) 	
#define IP0126_SEMAPHORE4 	 		(IP0126 + 0x810) 	
#define IP0126_SEMAPHORE5 	 		(IP0126 + 0x814) 	
#define IP0126_SEMAPHORE6 	 		(IP0126 + 0x818) 	
#define IP0126_SEMAPHORE7 	 		(IP0126 + 0x81c) 	
#define IP0126_SEMAPHORE8 	 		(IP0126 + 0x820) 	
#define IP0126_SEMAPHORE9 	 		(IP0126 + 0x824) 	
#define IP0126_SEMAPHORE10 	 		(IP0126 + 0x828) 	
#define IP0126_SEMAPHORE11 	 		(IP0126 + 0x82c) 	
#define IP0126_SEMAPHORE12 	 		(IP0126 + 0x830) 	
#define IP0126_SEMAPHORE13 	 		(IP0126 + 0x834) 	
#define IP0126_SEMAPHORE14 	 		(IP0126 + 0x838) 	
#define IP0126_SEMAPHORE15 	 		(IP0126 + 0x83c) 	
#define IP0126_CONFIG_ID 			(IP0126 + 0x900) 
#define IP0126_VENDOR_ID 			(IP0126 + 0x904) 
#define IP0126_CUSTOMER_ID 			(IP0126 + 0x920) 
#define IP0126_UNIQUE_DEVICE_ID_0 		(IP0126 + 0x924) 
#define IP0126_UNIQUE_DEVICE_ID_1 		(IP0126 + 0x928) 
#define IP0126_RANDOM_NUMBER 			(IP0126 + 0x980) 
#define IP0126_REG_NOISE_CONTROL 	 	(IP0126 + 0xa00) 
#define IP0126_REG_TEMP_CONTROL 	 	(IP0126 + 0xa04) 
#define IP0126_REG_SENSOR_CTRL 	 		(IP0126 + 0xa08) 
#define IP0126_RTC_CONTROL 	 		(IP0126 + 0xa10) 
#define IP0126_RTC_SEC_SET_VALUE 	 	(IP0126 + 0xa14)
#define IP0126_RTC_SEC_VALUE 			(IP0126 + 0xa18)
#define IP0126_RTC_USEC_VALUE 			(IP0126 + 0xa1c)
#define IP0126_RTC_TIMER 	 		(IP0126 + 0xa20)
#define IP0126_UIP_VCOMP1_CTRL 	 		(IP0126 + 0xb00)
#define IP0126_UIP_VCOMP2_CTRL 	 		(IP0126 + 0xb04)
#define IP0126_UIP_VCOMP3_CTRL 	 		(IP0126 + 0xb08)
#define IP0126_UIP_VCOMP1_GFX_COUNT 		(IP0126 + 0xb0c)
#define IP0126_UIP_VCOMP2_GFX_COUNT 		(IP0126 + 0xb10)
#define IP0126_UIP_VCOMP3_GFX_COUNT 		(IP0126 + 0xb14)
#define IP0126_MBVP_VDCOMP1_CTRL 	 	(IP0126 + 0xb20)
#define IP0126_MBVP_VDCOMP2_CTRL 	 	(IP0126 + 0xb24)
#define IP0126_MBVP_VDCOMP3_CTRL 	 	(IP0126 + 0xb28)
#define IP0126_MBVP_VDCOMP4_CTRL 	 	(IP0126 + 0xb2c)
#define IP0126_MBVP_VDCOMP5_CTRL 	 	(IP0126 + 0xb30)
#define IP0126_MBVP_VDCOMP6_CTRL 	 	(IP0126 + 0xb34)
#define IP0126_MBVP_VCOMP1_CTRL 	 	(IP0126 + 0xb40)
#define IP0126_MBVP_VCOMP2_CTRL 	 	(IP0126 + 0xb44)
#define IP0126_MBVP_VCOMP3_CTRL 	 	(IP0126 + 0xb48)
#define IP0126_MBVP_VCOMP4_CTRL 	 	(IP0126 + 0xb4c)
#define IP0126_MBVP_VCOMP5_CTRL 	 	(IP0126 + 0xb50)
#define IP0126_MBVP_VCOMP6_CTRL 	 	(IP0126 + 0xb54)
#define IP0126_MBVP_VCOMP1_GFX_COUNT 	 	(IP0126 + 0xb58) 	
#define IP0126_MBVP_VCOMP2_GFX_COUNT 	 	(IP0126 + 0xb5c) 	
#define IP0126_MBVP_VCOMP3_GFX_COUNT 	 	(IP0126 + 0xb60) 	
#define IP0126_MBVP_VCOMP4_GFX_COUNT 	 	(IP0126 + 0xb64) 	
#define IP0126_MBVP_VCOMP5_GFX_COUNT 	 	(IP0126 + 0xb68) 	
#define IP0126_MBVP_VCOMP6_GFX_COUNT 	 	(IP0126 + 0xb6c) 	
#define IP0126_CPIPE_VDCOMP1_CTRL 	 	(IP0126 + 0xb70) 	
#define IP0126_CPIPE_VDCOMP2_CTRL 	 	(IP0126 + 0xb74) 	
#define IP0126_CPIPE_VDCOMP3_CTRL 	 	(IP0126 + 0xb78) 	
#define IP0126_CPIPE_GFX_DCOMP1_CTRL 	 	(IP0126 + 0xb80) 	
#define IP0126_CPIPE_GFX_DCOMP2_CTRL 	 	(IP0126 + 0xb84) 	
#define IP0126_CPIPE_GFX_DCOMP3_CTRL 	 	(IP0126 + 0xb88) 	
#define IP0126_SPLITTER_CONTROL 	 	(IP0126 + 0xc00) 	
#define IP0126_MIPS24KE_L2BUF_CONFIG1 	 	(IP0126 + 0xc10) 	
#define IP0126_MIPS24KE_L2BUF_CONFIG2 	 	(IP0126 + 0xc14) 	
#define IP0126_MIPS4KE_L2BUF_CONFIG1 	 	(IP0126 + 0xc18) 	
#define IP0126_MIPS4KE_L2BUF_CONFIG2 	 	(IP0126 + 0xc1c) 	
#define IP0126_MSVD_SOURCE_ADDRESS_S0 	 	(IP0126 + 0xc24) 	
#define IP0126_MSVD_SOURCE_ADDRESS_S1 	 	(IP0126 + 0xc28) 	
#define IP0126_MSVD_SOURCE_ADDRESS_S2 	 	(IP0126 + 0xc2c) 	
#define IP0126_MSVD_SOURCE_ADDRESS_S3 	 	(IP0126 + 0xc30) 	
#define IP0126_MSVD_TARGET_ADDRESS_T0 	 	(IP0126 + 0xc34) 	
#define IP0126_MSVD_TARGET_ADDRESS_T1 	 	(IP0126 + 0xc38) 	
#define IP0126_MSVD_TARGET_ADDRESS_T2 	 	(IP0126 + 0xc3c) 	
#define IP0126_AVDSP_SOURCE_ADDRESS_S0 		(IP0126 + 0xc44) 	
#define IP0126_AVDSP_SOURCE_ADDRESS_S1 		(IP0126 + 0xc48) 	
#define IP0126_AVDSP_SOURCE_ADDRESS_S2 		(IP0126 + 0xc4c) 	
#define IP0126_AVDSP_SOURCE_ADDRESS_S3 		(IP0126 + 0xc50) 	
#define IP0126_AVDSP_TARGET_ADDRESS_T0 		(IP0126 + 0xc54) 	
#define IP0126_AVDSP_TARGET_ADDRESS_T1 		(IP0126 + 0xc58) 	
#define IP0126_AVDSP_TARGET_ADDRESS_T2 		(IP0126 + 0xc5c) 	
#define IP0126_NMCOPROC_SOURCE_ADDRESS_S0 	(IP0126 + 0xc64) 	
#define IP0126_NMCOPROC_SOURCE_ADDRESS_S1 	(IP0126 + 0xc68) 	
#define IP0126_NMCOPROC_SOURCE_ADDRESS_S2 	(IP0126 + 0xc6c) 	
#define IP0126_NMCOPROC_SOURCE_ADDRESS_S3 	(IP0126 + 0xc70) 	
#define IP0126_NMCOPROC_TARGET_ADDRESS_T0 	(IP0126 + 0xc74) 	
#define IP0126_NMCOPROC_TARGET_ADDRESS_T1 	(IP0126 + 0xc78) 	
#define IP0126_NMCOPROC_TARGET_ADDRESS_T2 	(IP0126 + 0xc7c) 	
#define IP0126_NM1_SOURCE_ADDRESS_S0 	 	(IP0126 + 0xc84) 	
#define IP0126_NM1_SOURCE_ADDRESS_S1 	 	(IP0126 + 0xc88) 	
#define IP0126_NM1_SOURCE_ADDRESS_S2 	 	(IP0126 + 0xc8c) 	
#define IP0126_NM1_SOURCE_ADDRESS_S3 	 	(IP0126 + 0xc90) 	
#define IP0126_NM1_TARGET_ADDRESS_T0 	 	(IP0126 + 0xc94) 	
#define IP0126_NM1_TARGET_ADDRESS_T1 	 	(IP0126 + 0xc98) 	
#define IP0126_NM1_TARGET_ADDRESS_T2 	 	(IP0126 + 0xc9c) 	
#define IP0126_NM2_SOURCE_ADDRESS_S0 	 	(IP0126 + 0xca4) 	
#define IP0126_NM2_SOURCE_ADDRESS_S1 	 	(IP0126 + 0xca8) 	
#define IP0126_NM2_SOURCE_ADDRESS_S2 	 	(IP0126 + 0xcac) 	
#define IP0126_NM2_SOURCE_ADDRESS_S3 	 	(IP0126 + 0xcb0) 	
#define IP0126_NM2_TARGET_ADDRESS_T0 	 	(IP0126 + 0xcb4) 	
#define IP0126_NM2_TARGET_ADDRESS_T1 	 	(IP0126 + 0xcb8) 	
#define IP0126_NM2_TARGET_ADDRESS_T2 	 	(IP0126 + 0xcbc) 	
#define IP0126_DEBUG_SETUP 	 	 	(IP0126 + 0xd00) 	
#define IP0126_DEBUG_CHANNEL_ACTIVATE 	 	(IP0126 + 0xd04) 	
#define IP0126_DEBUG_DTL_PORT_CONTROL 	 	(IP0126 + 0xd08) 	
#define IP0126_DEBUG_DTL_PORT_MONITOR 	 	(IP0126 + 0xd0c) 	
#define IP0126_DEBUG_PATTERN_1 	 		(IP0126 + 0xd10) 	
#define IP0126_DEBUG_PATTERN_2 	 		(IP0126 + 0xd14) 	
#define IP0126_DEBUG_PATTERN_3 	 		(IP0126 + 0xd18) 	
#define IP0126_DEBUG_PATTERN_4 	 		(IP0126 + 0xd1c) 	
#define IP0126_DEBUG_PATTERN_5 	 		(IP0126 + 0xd20) 	
#define IP0126_DEBUG_PATTERN_6 	 		(IP0126 + 0xd24) 	
#define IP0126_DEBUG_PATTERN_7 	 		(IP0126 + 0xd28) 	
#define IP0126_DEBUG_PATTERN_8 	 		(IP0126 + 0xd2c) 	
#define IP0126_DEBUG_PATTERN_MASK_1 	 	(IP0126 + 0xd30) 	
#define IP0126_DEBUG_PATTERN_MASK_2 	 	(IP0126 + 0xd34) 	
#define IP0126_DEBUG_PATTERN_MASK_3 	 	(IP0126 + 0xd38) 	
#define IP0126_DEBUG_PATTERN_MASK_4 	 	(IP0126 + 0xd3c) 	
#define IP0126_DEBUG_PATTERN_MASK_5 	 	(IP0126 + 0xd40) 	
#define IP0126_DEBUG_PATTERN_MASK_6 	 	(IP0126 + 0xd44) 	
#define IP0126_DEBUG_PATTERN_MASK_7 	 	(IP0126 + 0xd48) 	
#define IP0126_DEBUG_PATTERN_MASK_8 	 	(IP0126 + 0xd4c) 	
#define IP0126_DEBUG_LAST_WORD_ADDRESS 		(IP0126 + 0xd50) 	
#define IP0126_DEBUG_RAM_START_ADDRESS 		(IP0126 + 0xd54) 	
#define IP0126_DEBUG_RAM_END_ADDRESS 	 	(IP0126 + 0xd58) 	
#define IP0126_DEBUG_CAPTURE_END 	 	(IP0126 + 0xd5c) 	
#define IP0126_DEBUG_CONTROL 	 		(IP0126 + 0xd60) 	
#define IP0126_MVD_MAIN_CTRL 	 		(IP0126 + 0xe00) 	
#define IP0126_MVD_RESET_VECTOR 	 	(IP0126 + 0xe04) 	
#define IP0126_MVD_DMA_GATE_HI 	 		(IP0126 + 0xe08) 	
#define IP0126_MVD_DMA_GATE_LO 	 		(IP0126 + 0xe0c) 	
#define IP0126_INTERRUPT_CLR_ENABLE_MIPS24K 	(IP0126 + 0xf00) 	
#define IP0126_INTERRUPT_SET_ENABLE_MIPS24K 	(IP0126 + 0xf04) 	
#define IP0126_INTERRUPT_STATUS_MIPS24K 	(IP0126 + 0xf08) 	
#define IP0126_INTERRUPT_ENABLE_MIPS24K 	(IP0126 + 0xf0c) 	
#define IP0126_INTERRUPT_CLEAR_MIPS24K 		(IP0126 + 0xf10) 	
#define IP0126_INTERRUPT_SET_MIPS24K 		(IP0126 + 0xf14) 	
#define IP0126_INTERRUPT_CLR_ENABLE_TM_MSVD 	(IP0126 + 0xf20) 	
#define IP0126_INTERRUPT_SET_ENABLE_TM_MSVD 	(IP0126 + 0xf24) 	
#define IP0126_INTERRUPT_STATUS_TM_MSVD 	(IP0126 + 0xf28) 	
#define IP0126_INTERRUPT_ENABLE_TM_MSVD 	(IP0126 + 0xf2c) 	
#define IP0126_INTERRUPT_CLEAR_TM_MSVD 		(IP0126 + 0xf30) 	
#define IP0126_INTERRUPT_SET_TM_MSVD 		(IP0126 + 0xf34) 	
#define IP0126_INTERRUPT_CLR_ENABLE_TM_AVDSP 	(IP0126 + 0xf40) 	
#define IP0126_INTERRUPT_SET_ENABLE_TM_AVDSP 	(IP0126 + 0xf44) 	
#define IP0126_INTERRUPT_STATUS_TM_AVDSP 	(IP0126 + 0xf48) 	
#define IP0126_INTERRUPT_ENABLE_TM_AVDSP 	(IP0126 + 0xf4c) 	
#define IP0126_INTERRUPT_CLEAR_TM_AVDSP 	(IP0126 + 0xf50) 	
#define IP0126_INTERRUPT_SET_TM_AVDSP 		(IP0126 + 0xf54) 	
#define IP0126_INTERRUPT_CLR_ENABLE_TM_NM1 	(IP0126 + 0xf60) 	
#define IP0126_INTERRUPT_SET_ENABLE_TM_NM1 	(IP0126 + 0xf64) 	
#define IP0126_INTERRUPT_STATUS_TM_NM1 		(IP0126 + 0xf68) 	
#define IP0126_INTERRUPT_ENABLE_TM_NM1 		(IP0126 + 0xf6c) 	
#define IP0126_INTERRUPT_CLEAR_TM_NM1 		(IP0126 + 0xf70) 	
#define IP0126_INTERRUPT_SET_TM_NM1 		(IP0126 + 0xf74) 	
#define IP0126_INTERRUPT_CLR_ENABLE_TM_NM2 	(IP0126 + 0xf80) 	
#define IP0126_INTERRUPT_SET_ENABLE_TM_NM2 	(IP0126 + 0xf84) 	
#define IP0126_INTERRUPT_STATUS_TM_NM2 		(IP0126 + 0xf88) 	
#define IP0126_INTERRUPT_ENABLE_TM_NM2 		(IP0126 + 0xf8c) 	
#define IP0126_INTERRUPT_CLEAR_TM_NM2 		(IP0126 + 0xf90) 	
#define IP0126_INTERRUPT_SET_TM_NM2 		(IP0126 + 0xf94) 	
#define IP0126_MEM_SIZE_SEL 	 		(IP0126 + 0xff8) 	
#define IP0126_MODULE_ID 			(IP0126 + 0xffc) 	


/*
 * Register layout definitions
 */


#endif /* NXP_GLOBAL1_IP0126_H */
