/*
 * (C) Copyright 2003
 * Wolfgang Denk, DENX Software Engineering, wd@denx.de.
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#undef DEBUG

#include <common.h>
#include <command.h>
#include <malloc.h>
#include <asm/io.h>
#include <devices.h>
#include <timestamp.h>
#include <version.h>
#include <net.h>
#include <environment.h>
#include <nand.h>
#include <onenand_uboot.h>
#include <spi.h>
#include <i2c.h>

#ifdef CONFIG_SECURE_BOOT
extern void tmbtAuth_Init(void);
#endif

#ifdef CONFIG_SYS_MTD_PARTITION_EXTERNAL
extern void read_part_table(void);
extern void	read_tdf_key(void);
#endif

DECLARE_GLOBAL_DATA_PTR;

#if ( ((CONFIG_ENV_ADDR+CONFIG_ENV_SIZE) < CONFIG_SYS_MONITOR_BASE) || \
      (CONFIG_ENV_ADDR >= (CONFIG_SYS_MONITOR_BASE + CONFIG_SYS_MONITOR_LEN)) ) || \
    defined(CONFIG_ENV_IS_IN_NVRAM)
#define	TOTAL_MALLOC_LEN	(CONFIG_SYS_MALLOC_LEN + CONFIG_ENV_SIZE)
#else
#define	TOTAL_MALLOC_LEN	CONFIG_SYS_MALLOC_LEN
#endif

#ifdef CONFIG_TV55x_M1B_NAND_PATCH
	static void init_dma_arbitor(void);
	static void nand_pre_init(void);
#endif

#if defined(CONFIG_TV55X) && defined(CONFIG_TLB_MAPPING) 
	static void init_tlb(void);
#endif

extern int timer_init(void);

extern int incaip_set_cpuclk(void);

extern ulong uboot_end_data;
extern ulong uboot_end;

ulong monitor_flash_len;

const char version_string[] =
	U_BOOT_VERSION" (" U_BOOT_DATE " - " U_BOOT_TIME ")";

static char *failed = "*** failed ***\n";

/*
 * Begin and End of memory area for malloc(), and current "brk"
 */
static ulong mem_malloc_start;
static ulong mem_malloc_end;
static ulong mem_malloc_brk;

/*
 * mips_io_port_base is the begin of the address space to which x86 style
 * I/O ports are mapped.
 */
unsigned const long mips_io_port_base = -1;

int __board_early_init_f(void)
{
	/*
	 * Nothing to do in this dummy implementation
	 */
	return 0;
}

int board_early_init_f(void) __attribute__((weak, alias("__board_early_init_f")));

/*
 * The Malloc area is immediately below the monitor copy in DRAM
 */
static void mem_malloc_init (void)
{
	ulong dest_addr = CONFIG_SYS_MONITOR_BASE + gd->reloc_off;

#ifdef CONFIG_SYS_MALLOC_BASE
	#warning redefined malloc location
	/*
	 * Rellocate the malloc area to a customer defined location
	 * i.s.o adding it below the monitor.
	 */
	dest_addr = CONFIG_SYS_MALLOC_BASE + TOTAL_MALLOC_LEN;
#else
	#warning default malloc location
#endif

	mem_malloc_end = dest_addr;
	mem_malloc_start = dest_addr - TOTAL_MALLOC_LEN;
	mem_malloc_brk = mem_malloc_start;

	memset ((void *) mem_malloc_start,
		0,
		mem_malloc_end - mem_malloc_start);
}

void *sbrk (ptrdiff_t increment)
{
	ulong old = mem_malloc_brk;
	ulong new = old + increment;

	if ((new < mem_malloc_start) || (new > mem_malloc_end)) {
		return (NULL);
	}

    debug("-- New malloc brk @ 0x%08x\n", new);

	mem_malloc_brk = new;
	return ((void *) old);
}


static int init_func_ram (void)
{
#ifdef	CONFIG_BOARD_TYPES
	int board_type = gd->board_type;
#else
	int board_type = 0;	/* use dummy arg */
#endif
	puts ("DRAM:  ");

	if ((gd->ram_size = initdram (board_type)) > 0) {
		print_size (gd->ram_size, "\n");
		if (gd->ram_size == 512*1024*1024) {
			// temp patch in MIPs24KE_CONFIG  for 512 MB DDR in case ejtag is connected.
			writel(0x0007ffe0, 0x70e63230);
		}
		return (0);
	}
	puts (failed);
	return (1);
}

static int display_banner(void)
{

	printf ("\n\n%s\n\n", version_string);
	return (0);
}

#ifndef CONFIG_SYS_NO_FLASH
static void display_flash_config(ulong size)
{
	puts ("Flash: ");
	print_size (size, "\n");
}
#endif

static int init_baudrate (void)
{
	char tmp[64];	/* long enough for environment variables */
	int i = getenv_r ("baudrate", tmp, sizeof (tmp));

	gd->baudrate = (i > 0)
			? (int) simple_strtoul (tmp, NULL, 10)
			: CONFIG_BAUDRATE;

	return (0);
}


/*
 * Breath some life into the board...
 *
 * The first part of initialization is running from Flash memory;
 * its main purpose is to initialize the RAM so that we
 * can relocate the monitor code to RAM.
 */

/*
 * All attempts to come up with a "common" initialization sequence
 * that works for all boards and architectures failed: some of the
 * requirements are just _too_ different. To get rid of the resulting
 * mess of board dependend #ifdef'ed code we now make the whole
 * initialization sequence configurable to the user.
 *
 * The requirements for any new initalization function is simple: it
 * receives a pointer to the "global data" structure as it's only
 * argument, and returns an integer return code, where 0 means
 * "continue" and != 0 means "fatal error, hang the system".
 */
typedef int (init_fnc_t) (void);

init_fnc_t *init_sequence[] = {
	board_early_init_f,
	timer_init,
	env_init,		/* initialize environment */
#ifdef CONFIG_INCA_IP
	incaip_set_cpuclk,	/* set cpu clock according to environment variable */
#endif
	init_baudrate,		/* initialze baudrate settings */
	serial_init,		/* serial communications setup */
	console_init_f,
	display_banner,		/* say that we are here */
	checkboard,
	init_func_ram,
	NULL,
};


void board_init_f(ulong bootflag)
{
	gd_t gd_data, *id;
	bd_t *bd;
	init_fnc_t **init_fnc_ptr;
	ulong addr, addr_sp, len = (ulong)&uboot_end - CONFIG_SYS_MONITOR_BASE;
	ulong *s;
	ulong tsu;
        ulong scratch;
#ifdef CONFIG_PURPLE
	void copy_code (ulong);
#endif
	tsu = readl(MMIO_BASE + 0x0014C0c0);
        scratch = (IP0126 + 0x500 + 44);
        writel(tsu, scratch);
	/* Pointer is writable since we allocated a register for it.
	 */
	gd = &gd_data;
	/* compiler optimization barrier needed for GCC >= 3.4 */
	__asm__ __volatile__("": : :"memory");

	memset ((void *)gd, 0, sizeof (gd_t));

	for (init_fnc_ptr = init_sequence; *init_fnc_ptr; ++init_fnc_ptr) {
		if ((*init_fnc_ptr)() != 0) {
			hang ();
		}
	}

#ifdef CONFIG_SYS_MTD_PARTITION_EXTERNAL
	/* Saveguard the partition data from the u-boot image */
  	read_part_table();

	/* Saveguard the tdf key from the u-boot image */
	read_tdf_key();
#endif

#ifdef CONFIG_SKIP_RELOCATE_UBOOT 
	/*
	 * If we do not relocate uboot we can stick to the 
	 * TEXT_BASE provided in the configs
	 */
    	debug("Skip MIPS uboot relocation\n");
	addr = CONFIG_SYS_MONITOR_BASE;
	debug ("Reserving %ldk for U-Boot at: %08lx\n", len >> 10, addr);
#else
	/*
	 * Now that we have DRAM mapped and working, we can
	 * relocate the code and continue running from DRAM.
	 */
	addr = CONFIG_SYS_SDRAM_BASE + gd->ram_size;

	/* We can reserve some RAM "on top" here.
	 */

	/* round down to next 4 kB limit.
	 */
	addr &= ~(4096 - 1);
	debug ("Top of RAM usable for U-Boot at: %08lx\n", addr);

	/* Reserve memory for U-Boot code, data & bss
	 * round down to next 16 kB limit
	 */
	addr -= len;
	addr &= ~(16 * 1024 - 1);

	debug ("Reserving %ldk for U-Boot at: %08lx\n", len >> 10, addr);
#endif
	 /* Reserve memory for malloc() arena.
	 */
#ifdef CONFIG_SYS_MALLOC_BASE
	addr_sp = addr;
#else
	addr_sp = addr - TOTAL_MALLOC_LEN;
#endif
	debug ("Reserving %dk for malloc() at: %08lx\n",
			TOTAL_MALLOC_LEN >> 10, addr_sp);

	/*
	 * (permanently) allocate a Board Info struct
	 * and a permanent copy of the "global" data
	 */
	addr_sp -= sizeof(bd_t);
	bd = (bd_t *)addr_sp;
	gd->bd = bd;
	debug ("Reserving %zu Bytes for Board Info at: %08lx\n",
			sizeof(bd_t), addr_sp);

	addr_sp -= sizeof(gd_t);
	id = (gd_t *)addr_sp;
	debug ("Reserving %zu Bytes for Global Data at: %08lx\n",
			sizeof (gd_t), addr_sp);

	/* Reserve memory for boot params.
	 */
	addr_sp -= CONFIG_SYS_BOOTPARAMS_LEN;
	bd->bi_boot_params = addr_sp;
	debug ("Reserving %dk for boot params() at: %08lx\n",
			CONFIG_SYS_BOOTPARAMS_LEN >> 10, addr_sp);

	/*
	 * Finally, we set up a new (bigger) stack.
	 *
	 * Leave some safety gap for SP, force alignment on 16 byte boundary
	 * Clear initial stack frame
	 */
	addr_sp -= 16;
	addr_sp &= ~0xF;
	s = (ulong *)addr_sp;
	*s-- = 0;
	*s-- = 0;
	addr_sp = (ulong)s;
	debug ("Stack Pointer at: %08lx\n", addr_sp);

	/*
	 * Save local variables to board info struct
	 */
	bd->bi_memstart	= CONFIG_SYS_SDRAM_BASE;	/* start of  DRAM memory */
	bd->bi_memsize	= gd->ram_size;		/* size  of  DRAM memory in bytes */
	bd->bi_baudrate	= gd->baudrate;		/* Console Baudrate */

	memcpy (id, (void *)gd, sizeof (gd_t));

	/* On the purple board we copy the code in a special way
	 * in order to solve flash problems
	 */
#ifdef CONFIG_PURPLE
	copy_code(addr);
#endif

	relocate_code (addr_sp, id, addr);

	/* NOTREACHED - relocate_code() does not return */
}
/************************************************************************
 *
 * This is the next part if the initialization sequence: we are now
 * running from RAM and have a "normal" C environment, i. e. global
 * data can be written, BSS has been cleared, the stack size in not
 * that critical any more, etc.
 *
 ************************************************************************
 */

void board_init_r (gd_t *id, ulong dest_addr)
{
	cmd_tbl_t *cmdtp;
#ifndef CONFIG_SYS_NO_FLASH
	ulong size;
#endif
	extern void malloc_bin_reloc (void);
#ifndef CONFIG_ENV_IS_NOWHERE
	extern char * env_name_spec;
#endif
	char *s, *e;
	bd_t *bd;
	int i;
	ulong tsu;
        ulong scratch;

	gd = id;
	gd->flags |= GD_FLG_RELOC;	/* tell others: relocation done */

	debug ("Now running in RAM - U-Boot at: %08lx\n", dest_addr);

	gd->reloc_off = dest_addr - CONFIG_SYS_MONITOR_BASE;

	monitor_flash_len = (ulong)&uboot_end_data - dest_addr;

	/*
	 * We have to relocate the command table manually
	 */
	for (cmdtp = &__u_boot_cmd_start; cmdtp !=  &__u_boot_cmd_end; cmdtp++) {
		ulong addr;

		addr = (ulong) (cmdtp->cmd) + gd->reloc_off;
#if 0
		printf ("Command \"%s\": 0x%08lx => 0x%08lx\n",
				cmdtp->name, (ulong) (cmdtp->cmd), addr);
#endif
		cmdtp->cmd =
			(int (*)(struct cmd_tbl_s *, int, int, char *[]))addr;

		addr = (ulong)(cmdtp->name) + gd->reloc_off;
		cmdtp->name = (char *)addr;

		if (cmdtp->usage) {
			addr = (ulong)(cmdtp->usage) + gd->reloc_off;
			cmdtp->usage = (char *)addr;
		}
#ifdef	CONFIG_SYS_LONGHELP
		if (cmdtp->help) {
			addr = (ulong)(cmdtp->help) + gd->reloc_off;
			cmdtp->help = (char *)addr;
		}
#endif
	}
	/* there are some other pointer constants we must deal with */
#ifndef CONFIG_ENV_IS_NOWHERE
	env_name_spec += gd->reloc_off;
#endif

	bd = gd->bd;

#ifndef CONFIG_SYS_NO_FLASH
	/* configure available FLASH banks */
	size = flash_init();
	display_flash_config (size);
	bd->bi_flashsize = size;
#endif

	bd->bi_flashstart = CONFIG_SYS_FLASH_BASE;
#if CONFIG_SYS_MONITOR_BASE == CONFIG_SYS_FLASH_BASE
	bd->bi_flashoffset = monitor_flash_len;	/* reserved area for U-Boot */
#else
	bd->bi_flashoffset = 0;
#endif

	/* initialize malloc() area */
	mem_malloc_init();
	malloc_bin_reloc();

#if defined(CONFIG_TV55X) && defined(CONFIG_TLB_MAPPING) 
	init_tlb();
#endif

	/* Secure boot */
#ifdef CONFIG_SECURE_BOOT
	tmbtAuth_Init();
#endif

#ifdef CONFIG_CMD_NAND

#ifdef CONFIG_TV55x_M1B_NAND_PATCH
	nand_pre_init();
#endif

	puts ("NAND:  ");
	nand_init ();		/* go init the NAND */

#endif

#if defined(CONFIG_CMD_ONENAND)
	onenand_init();
#endif

	/* relocate environment function pointers etc. */
	env_relocate();

#ifdef CONFIG_CMD_NET
	/* board MAC address */
	s = getenv ("ethaddr");
	for (i = 0; i < 6; ++i) {
		bd->bi_enetaddr[i] = s ? simple_strtoul (s, &e, 16) : 0;
		if (s)
			s = (*e) ? e + 1 : e;
	}

	/* IP Address */
	bd->bi_ip_addr = getenv_IPaddr("ipaddr");
#endif

#if defined(CONFIG_PCI) 
	/*
	 * Do pci configuration
	 */
	pci_init();
#endif

#if defined(CONFIG_NXP_I2C)
        //i2c_init (CONFIG_SYS_I2C_SPEED, CONFIG_SYS_I2C_SLAVE);
#endif

/** leave this here (after malloc(), environment and PCI are working) **/
	/* Initialize devices */
	devices_init ();

	jumptable_init ();

	/* Initialize the console (after the relocation and devices init) */
	console_init_r ();
/** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** ** **/

	/* Initialize from environment */
	if ((s = getenv ("loadaddr")) != NULL) {
		load_addr = simple_strtoul (s, NULL, 16);
	}
#if defined(CONFIG_CMD_NET)
	if ((s = getenv ("bootfile")) != NULL) {
		copy_filename (BootFile, s, sizeof (BootFile));
	}
#endif

#ifdef CONFIG_CMD_SPI
	puts ("SPI:   ");
	spi_init ();		/* go init the SPI */
	puts ("ready\n");
#endif

#if defined(CONFIG_MISC_INIT_R)
	/* miscellaneous platform dependent initialisations */
	misc_init_r ();
#endif

#if defined(CONFIG_CMD_NET)
#if defined(CONFIG_NET_MULTI)
	puts ("Net:   ");
#endif
	eth_initialize(gd->bd);
#endif

	tsu = readl(MMIO_BASE + 0x0014C0c0);
        scratch = (IP0126 + 0x500 + 48);
        writel(tsu, scratch);

	/* main_loop() can return to retry autoboot, if so just run it again. */
	for (;;) {
		main_loop ();
	}

	/* NOTREACHED - no way out of command loop except booting */
}

void hang (void)
{
	puts ("### ERROR ### Please RESET the board ###\n");
	for (;;);
}

#ifdef CONFIG_TV55x_M1B_NAND_PATCH
/* YW: copied settings from bootscript v8.0 */
static void init_dma_arbitor(void) 
{
	// DMA Arbiter Setup
	writel(0x00000018,(MMIO_BASE + 0x00052200));
	writel(0x0000000f,(MMIO_BASE + 0x00052204));
	writel(0x00000011,(MMIO_BASE + 0x00052208));
	writel(0x00000013,(MMIO_BASE + 0x0005220c));
	writel(0x00000010,(MMIO_BASE + 0x00052210));
	writel(0x00000012,(MMIO_BASE + 0x00052214));
	writel(0x00000015,(MMIO_BASE + 0x00052218));
	writel(0x00000006,(MMIO_BASE + 0x0005221c));
	writel(0x00000007,(MMIO_BASE + 0x00052220));
	writel(0x00000008,(MMIO_BASE + 0x00052224));
	writel(0x00000002,(MMIO_BASE + 0x00052228));
	writel(0x00000003,(MMIO_BASE + 0x0005222c));
	writel(0x00000014,(MMIO_BASE + 0x00052230));
	writel(0x0000000d,(MMIO_BASE + 0x00052234));
	writel(0x00000009,(MMIO_BASE + 0x00052238));
	writel(0x0000000a,(MMIO_BASE + 0x0005223c));
	writel(0x0000000e,(MMIO_BASE + 0x00052240));
	writel(0x0000000b,(MMIO_BASE + 0x00052244));
	writel(0x0000000c,(MMIO_BASE + 0x00052248));
	writel(0x00000004,(MMIO_BASE + 0x0005224c));
	writel(0x00000000,(MMIO_BASE + 0x00052250));
	writel(0x00000001,(MMIO_BASE + 0x00052254));
	writel(0x00000005,(MMIO_BASE + 0x00052258));
	writel(0x00000016,(MMIO_BASE + 0x0005225c));
	writel(0x00000017,(MMIO_BASE + 0x00052260));
	writel(0x00000018,(MMIO_BASE + 0x00053200));
	writel(0x0000000f,(MMIO_BASE + 0x00053204));
	writel(0x00000011,(MMIO_BASE + 0x00053208));
	writel(0x00000013,(MMIO_BASE + 0x0005320c));
	writel(0x00000010,(MMIO_BASE + 0x00053210));
	writel(0x00000012,(MMIO_BASE + 0x00053214));
	writel(0x00000015,(MMIO_BASE + 0x00053218));
	writel(0x00000006,(MMIO_BASE + 0x0005321c));
	writel(0x00000007,(MMIO_BASE + 0x00053220));
	writel(0x00000008,(MMIO_BASE + 0x00053224));
	writel(0x00000002,(MMIO_BASE + 0x00053228));
	writel(0x00000003,(MMIO_BASE + 0x0005322c));
	writel(0x00000014,(MMIO_BASE + 0x00053230));
	writel(0x0000000d,(MMIO_BASE + 0x00053234));
	writel(0x00000009,(MMIO_BASE + 0x00053238));
	writel(0x0000000a,(MMIO_BASE + 0x0005323c));
	writel(0x0000000e,(MMIO_BASE + 0x00053240));
	writel(0x0000000b,(MMIO_BASE + 0x00053244));
	writel(0x0000000c,(MMIO_BASE + 0x00053248));
	writel(0x00000004,(MMIO_BASE + 0x0005324c));
	writel(0x00000000,(MMIO_BASE + 0x00053250));
	writel(0x00000001,(MMIO_BASE + 0x00053254));
	writel(0x00000005,(MMIO_BASE + 0x00053258));
	writel(0x00000016,(MMIO_BASE + 0x0005325c));
	writel(0x00000017,(MMIO_BASE + 0x00053260));
	writel(0x00001900,(MMIO_BASE + 0x00052800));
	writel(0x00001900,(MMIO_BASE + 0x00053800));
	
	// Arbitration Start
	writel(0x00000001,(MMIO_BASE + 0x00052900));
	writel(0x00000001,(MMIO_BASE + 0x00053900));
	writel(0x00000001,(MMIO_BASE + 0x0002e900));
	writel(0x00000001,(MMIO_BASE + 0x00030900));
}

static void nand_pre_init(void) 
{
	// PCI setup
	writel(0x000000CA, (MMIO_BASE + 0x0004003C));
	writel(0x71C01F83, (MMIO_BASE + 0x00040010));

	// DMA ARB1/2
	init_dma_arbitor();

	writel(0x00000003, (MMIO_BASE + 0x0002b04c));
	writel(0x0000F101, (MMIO_BASE + 0x00063600));

	// Nand type / timing
	writel(0x00000014, (MMIO_BASE + 0x0002b04c));
	writel(0x02111114, (MMIO_BASE + 0x0002b050));
	writel(0x01001111, (MMIO_BASE + 0x0002b054));
	
	// Set EBI_CTRL to 1
	writel(0x1,     (MMIO_BASE + 0x0002b010));
	writel(0x500fe, (MMIO_BASE + 0x0002b000));
}
#endif

#if defined(CONFIG_TV55X) && defined(CONFIG_TLB_MAPPING) 

typedef void (*tlb_for_mmio)(unsigned long addr);
static const unsigned long mmio_tlb[] = 
{
/* mask for 4meg */
   0x3c02007f,0x3442e000,0x40822800,
/* index 0 */
   0x40800000,
/* virtual address */
   0x3c02df80,0x40825000,
/* physical addr reg4 $a0 */
   0x42582,0x42400,
/* uncached in top 4meg */
   0x24840017,0x40841800,
/* cached in bottom 4meg */
   0x24840008,0x40841000,
/* tlb write */
   0x3e00008,0x42000002
};


static void init_tlb(void) {
	// tlb mapping
	unsigned long retval;	

	tlb_for_mmio func = (tlb_for_mmio)mmio_tlb;

	//puts("setting up tlb.....\n");
	retval	= 0x70C00000;
	func(retval);
}
#endif 	
