#include "wrapper.h"
#include "asm/io.h"
#include "auth.h"

#include "./sha256.h"

#define U32s_PER_BIGNUM             64
#define SIGNATURE_KEY               2048
#define SIGNATURE_U8_PER_KEY        (SIGNATURE_KEY/8)
#define SIGNATURE_U32_PER_KEY       (SIGNATURE_U8_PER_KEY/4)

#undef MEASURE_PERFORMANCE

DECLARE_GLOBAL_DATA_PTR;

#if 0                           
#define TSU_REG         ((volatile unsigned int*)(MMIO_BASE + 0x14c0c0))
#endif

#define HW_SEM0         ((volatile unsigned int*)(MMIO_BASE + 0x063800))
#define HW_SEM1         ((volatile unsigned int*)(MMIO_BASE + 0x063804))
#define HW_SEM2         ((volatile unsigned int*)(MMIO_BASE + 0x063808))
#define HW_SEM3         ((volatile unsigned int*)(MMIO_BASE + 0x06380C))
#define HW_SEM4         ((volatile unsigned int*)(MMIO_BASE + 0x063810))
#define HW_SEM5         ((volatile unsigned int*)(MMIO_BASE + 0x063814))

/* always referenced as a pointer first word is least significant */
#define Bignum_t        unsigned int   

typedef unsigned long BignumInt;
typedef BignumInt *Bignum;

/*
**  1024 bits customer public key, little endian.
*/
//extern unsigned long TdfPublicKey[U32s_PER_BIGNUM * 2];
unsigned long *TdfPublicKey;

/*
**  use_trimedia_authentication
**
**  This variable is used to indicate whether the bootrom authentication needs to be
**  used or the authentication done by the TriMedia.
**

**  Currently the moment to switch from bootrom code to TriMedia authentication is done
**  once the channel decoder download application has started, see function startTM.
**
**  The TdfLoader component uses this the select the appropriate authentication functionality. 
**
**  Initial internal bootrom authentication application must be used 
*/
static int use_trimedia_authentication;

/* BIS Section (0x7FFE000), Used to store the sha1 computed hash value, it consist out of 5 32bit values. */
static volatile unsigned long 	BIS_HASH;
static volatile unsigned long 	*bis_hash;

static volatile unsigned long 	*bis_sha_memory;
static volatile unsigned long 	*bis_sha_size;
static volatile unsigned long 	*bis_sha_action;

//static volatile unsigned long 	*bis_result_self_test = (volatile unsigned long *)(BIS_HASH + 0x100);
static volatile long 	*bis_result;
static volatile unsigned long 	*bis_performance;

static volatile unsigned long 	*BIS_COPY_SHA_MEMORY;
static volatile unsigned long	*BIS_COPY_SHA_SIZE;
static volatile unsigned long	*BIS_COPY_SHA_ACTION;
static volatile unsigned long	*BIS_COPY_REF_COUNT;

static unsigned int TempHW_SEM0;
static unsigned int TempHW_SEM1;
static unsigned int TempHW_SEM2;

unsigned long 		rsa_decrypt[U32s_PER_BIGNUM];
static SHA256 		sha; 

static struct rsa_info
{
    unsigned int  modulus[U32s_PER_BIGNUM]; /* as defined in key */
    unsigned int  exponent;                 /* as defined in key */
    unsigned long workarea;                /* address of a work area */
} rsa_data;

extern void *mtd_part_read_key(void);


void tmbtAuth_RestoreHWSemValues(void);

#ifdef CONFIG_TV55X
static int (*bootrom_rsa)(  Bignum_t *OutputBlock, 
							Bignum_t *InputBlock, 
							Bignum_t *p, 
							Bignum_t *d, 
							Bignum_t *workarea );

static void (*sha256_begin) (SHA256 *sha);
static void (*sha256_next)  (SHA256 *sha, uchar *what, int len);
static void (*sha256_finish)(SHA256 *sha, ulong *out);
#endif

/*
**	Temporary storage area for rsa_decode
*/
static 	unsigned char    wa[2048];

/*
**  tmbtAuth_Compare
**
**  Compares the computed SHA-1 value with the decrypted SHA-1 value
**
**      rsa_exp     Exponent of the public key
**      rsa_mod     Modulus of the public key
**      rsa_sig     Signature to decrypted and compare with
*/
unsigned int tmbtAuth_Compare(unsigned long *rsa_sig)
{
    unsigned int    ret;
    int 			c;
    int 			i;

	/*
	**	Assume the worst
	*/
    ret = TMDL_ERR_TDF_AUTH_ERR;

    /* 
    **  Wait for TM authenticating its current block before requesting to authenticate the 
    **  next block
    */
	if (use_trimedia_authentication) {
		tmbtAuth_AcquireSem1();
	}

    dump("iHash",    (unsigned char *)bis_hash, 256);

    /* Public key is stored in BE form, RSA needs LE	*/
    rsa_data.exponent = TdfPublicKey[U32s_PER_BIGNUM];
    rsa_data.workarea = (unsigned long)wa;

	mydebug("TdfPublicKey[U32s_PER_BIGNUM]=0x%lx (%ld)\n",
		TdfPublicKey[U32s_PER_BIGNUM], TdfPublicKey[U32s_PER_BIGNUM]);
	mydebug("rsa_data.exponent=0x%x (%d)\n",
		rsa_data.exponent, rsa_data.exponent);

#if 0
    ts = *TSU_REG;
#endif

	myinfo("Going to call rsa_decode\n");
#ifdef CONFIG_TV55X
	bootrom_rsa( (Bignum_t*)((void *)&(rsa_decrypt[0])), 
				 (Bignum_t*)rsa_sig, 
				 (Bignum_t*)((void *)&(TdfPublicKey[0])), 
				 (Bignum_t*)&(TdfPublicKey[U32s_PER_BIGNUM]), 
				 (Bignum_t*)((void *)rsa_data.workarea) );
#else
	rsa_decode_256( (Bignum_t*)((void *)&(rsa_decrypt[0])), 
				 (Bignum_t*)rsa_sig, 
				 (Bignum_t*)((void *)&(TdfPublicKey[0])), 
				 (Bignum_t*)&(TdfPublicKey[U32s_PER_BIGNUM]), 
				 (Bignum_t*)((void *)rsa_data.workarea) );
#endif
	dump("Decypt ras_decrypt", (unsigned char *)rsa_decrypt, 256);

	c = 0;
	for (i=0; i<8; i++) {
		c |= (bis_hash[i] != rsa_decrypt[i]);
	}
	
	if (c == 0)
    {
        ret = 0;
    }
    else
    {
        ret = TMDL_ERR_TDF_AUTH_ERR; 
    }

    /*
    **  Remove rsa decryption result from memory
    */
    for (i = 0; i < U32s_PER_BIGNUM; i++)
    {
        rsa_decrypt[i] = 0L;    
    }

    /*
    **  Make sure it is not only erased in cache but also in physical memory    
    */
    //DCacheIndexWritebackInvalidate();
	//invalidate_dcache_range(rsa_decrypt, sizeof(rsa_decrypt));
	
    /*
    **  Init HW_SEM so we continue the next time
    */
    tmbtAuth_ReleaseSem1();

    return ret;
}

/*
**  tmbtAuth_AcquireSem1
**
**
*/
void tmbtAuth_AcquireSem1(void)
{
    static int i = 0xAAA;
    
    i = ((~i) & 0x00000FFF); // It can only write when non-zero, also make sure it is never 0
    
    do
    {
        *HW_SEM1 = i;
    }   while (*HW_SEM1 != i);
}

/*
**  tmbtAuth_AcquireClient
**
**
*/
void tmbtAuth_AcquireClient(void)
{
    static int i = 0xAAA;
    
    i = ((~i) & 0x00000FFF); // It can only write when non-zero, also make sure it is never 0

	
    do
    {
        *HW_SEM1 = i;
    }   while (*HW_SEM1 != i);
}

/*
**  tmbtAuth_ReleaseSem0
**
**
*/
void tmbtAuth_ReleaseSem0(void)
{
	//???
}

/*
**  tmbtAuth_ReleaseSem1
**
**
*/
void tmbtAuth_ReleaseSem1(void)
{
    *HW_SEM1 = 0;
}

/*
**  tmbtAuth_ReleaseServer
**
**
*/
void tmbtAuth_ReleaseServer(void)
{
    *HW_SEM0 = 0;
}

/*
**  tmbtAuth_Init
**
**
*/
void tmbtAuth_Init(void)
{
	//int				i;

	/* Take a backup of the Semaphore values. Need to restore these values in case of a HotBoot for TM*/
	TempHW_SEM0 = *HW_SEM0;
	TempHW_SEM1 = *HW_SEM1;
	TempHW_SEM2 = *HW_SEM2;

        use_trimedia_authentication = 0;

	// BIS HASH info
	BIS_HASH  	  = (volatile unsigned char *)(gd->ram_size - 0x2000);
	bis_hash 	  = (volatile unsigned long *)(BIS_HASH);
	bis_sha_memory 	  = (volatile unsigned long *)(BIS_HASH + 0x80);
	bis_sha_size	  = (volatile unsigned long *)(BIS_HASH + 0x84);
	bis_sha_action 	  = (volatile unsigned long *)(BIS_HASH + 0x88);

	mydebug("BIS_HASH is: 0x%lx\n", BIS_HASH);
    mydebug("bis_hash is: 0x%lx\n", bis_hash);
    mydebug("gd->ram_size is: 0x%lx\n", gd->ram_size);
		
	//bis_result_self_test = (volatile unsigned long *)(BIS_HASH + 0x100);
	bis_result		  = (volatile unsigned long *)(BIS_HASH + 0x100);
	bis_performance	  = (volatile unsigned long *)(BIS_HASH + 0x200);
	
	BIS_COPY_SHA_MEMORY		= (volatile unsigned long *)(BIS_HASH + 0x300);
	BIS_COPY_SHA_SIZE	 	= (volatile unsigned long *)(BIS_HASH + 0x304);
	BIS_COPY_SHA_ACTION 	= (volatile unsigned long *)(BIS_HASH + 0x308);
	BIS_COPY_REF_COUNT  	= (volatile unsigned long *)(BIS_HASH + 0x30C);


	//TdfPublicKey = (unsigned long *)(0xA004F600);
	//dump("public key:", (unsigned char *)TdfPublicKey, 512);
	TdfPublicKey =  (unsigned long *)mtd_part_read_key();
	mydebug("TdfPublicKey@0x%08x\n", TdfPublicKey);

	dump("TdfPublicKey=\n", TdfPublicKey, 512);

#ifdef CONFIG_TV55X
	// we use bootrom code for 550
	bootrom_rsa   = (unsigned long)(0xdfa20000 + 0x0ecc);
	sha256_begin  = (unsigned long)(0xdfa20000 + 0x0484);
	sha256_next   = (unsigned long)(0xdfa20000 + 0x0870);
	sha256_finish = (unsigned long)(0xdfa20000 + 0x0970);

	mydebug("bootrom_rsa at: 0x%lx\n", (unsigned long)bootrom_rsa);
	mydebug("sha256_begin at: 0x%lx\n", (unsigned long)sha256_begin);
	mydebug("sha256_next at: 0x%lx\n", (unsigned long)sha256_next);
	mydebug("sha256_finish at: 0x%lx\n", (unsigned long)sha256_finish);
#endif

}

/*
**  tmbtAuth_Dispatch
**
**
*/
void tmbtAuth_Dispatch(void *pdata, long size, int action, int do_auth)
{
    static int dispatch_ref_count;
    
	// Show authentication progress
	puts(".");
	
	mydebug("====>pdata:%lx, size:%lx, action:%d, do_auth:%d\n", 
		(unsigned long)pdata, (unsigned long)size, action, do_auth);
	
    if ((use_trimedia_authentication == 1) && do_auth)
    {
		myinfo("*********************USE TM for AUTHENTICATION*********************\n");

        /* 
        **  Wait for TM authenticating its current block before requesting to authenticate the next block
        */
        tmbtAuth_AcquireClient();
		if (*bis_result) {
			printf("lzo compressed data violation, err=%d\n", *bis_result); 
			printf("*BIS_COPY_SHA_MEMORY: %08lx\n", *BIS_COPY_SHA_MEMORY);
			printf("*BIS_COPY_SHA_SIZE	: %08lx\n", *BIS_COPY_SHA_SIZE);
			printf("*BIS_COPY_SHA_ACTION: %08lx\n", *BIS_COPY_SHA_ACTION);
			printf("*BIS_COPY_REF_COUNT : %ld\n",	*BIS_COPY_REF_COUNT);
		}

        dispatch_ref_count++;
        
        if (action == AUTH_SHA_FIRST)
        {   
            dispatch_ref_count = 0;
        }

        mydebug("BIS_HASH: %08lx\n", (unsigned long)BIS_HASH);
        mydebug("pdata: %08lx\n", (unsigned long)pdata);
        mydebug("size:    %08lx\n", size);
        mydebug("actiion: %d\n", dispatch_ref_count);
        mydebug("dispatch_ref_count: %d\n", dispatch_ref_count);

        /*
        **  File content is stored at the given location 
        */
		writel(((unsigned long)pdata) & 0x1FFFFFFF, bis_sha_memory);
		writel((unsigned long)size,   bis_sha_size);
		writel((unsigned long)action, bis_sha_action);
		
        if (action == AUTH_SHA_GOODBYE)
        {
           myinfo("AUTH_SHA_GOODBYE\n");
        }

		//YW: not necessary since BIS is in uncached memory
        //DCacheIndexWritebackInvalidate();
        
        /* 
        **  Signal TM that a new request is available 
        */
        tmbtAuth_ReleaseServer();

        mydebug("*BIS_COPY_SHA_MEMORY: %08lx\n", *BIS_COPY_SHA_MEMORY);
        mydebug("*BIS_COPY_SHA_SIZE  : %08lx\n", *BIS_COPY_SHA_SIZE);
        mydebug("*BIS_COPY_SHA_ACTION: %08lx\n", *BIS_COPY_SHA_ACTION);
        mydebug("*BIS_COPY_REF_COUNT : %ld\n",   *BIS_COPY_REF_COUNT);

#ifdef MEASURE_PERFORMANCE
		printf("*bis_performance : %ld\n",   *bis_performance);
#endif
	}
    else if (do_auth)
    {
    	static int use_lzo = 0;
		
	   myinfo(".......................USE MIPS for AUTHENTICATION.......................\n");

		switch (action)
		{	
        case AUTH_SHA_COMPLETE:
			sha256_begin(&sha);
			sha256_next (&sha, (unsigned char *)pdata, size);
			sha256_finish(&sha, bis_hash);
            break;
            
       	case AUTH_SHA_FIRST:
            sha256_begin(&sha);
            sha256_next(&sha, (unsigned char *)pdata, size);
            break;
            
        case AUTH_SHA_NEXT:
		case AUTH_LZO_FIRST:
            sha256_next(&sha, (unsigned char *)pdata, size);
            break;
            
        case AUTH_SHA_LAST:
            sha256_next(&sha, (unsigned char *)pdata, size);
            sha256_finish(&sha, bis_hash);
            break;
            
		case AUTH_LZO_INIT:
			use_lzo = 1;
			break;

		default:
			break;            
		};

		if (use_lzo) {
			// Decompress lzo image
			lzo_dispatch(pdata, size, action, do_auth);
		}
		
		if (action == AUTH_SHA_GOODBYE) {
			use_lzo = 0;
		}
    }
}

/* Wait for tm authentication to finish calcuting Hash for one chunk */
void tmbtAuth_wait(void) 
{
	if (use_trimedia_authentication)
	{
		while (readl(HW_SEM1) != 0)
			;
	}	
}

/*
**  tmbtAuth_Start
**
**	Precondition: has to be called before the tmAuth app is started but after the
**	tmAuth app is loaded
*/
void tmbtAuth_Start(void)
{
	/*
    **  Initially the authentication has to wait
    */

    /* From now on use the TriMedia to authenticate applications */
    use_trimedia_authentication = 1;
}

/*
**  tmbtAuth_Stop
**
**
*/
void tmbtAuth_Stop(void)
{
    /* Time to say goodbye      */
    *HW_SEM0 = 0;
	*HW_SEM1 = 0;
    *HW_SEM2 = 0;

    use_trimedia_authentication = 0;
}

void tmbtAuth_RestoreHWSemValues(void)
{
	*HW_SEM0 = 0;
	*HW_SEM0 = TempHW_SEM0;

	*HW_SEM1 = 0;
	*HW_SEM1 = TempHW_SEM1;

	*HW_SEM2 = 0;
	*HW_SEM2 = TempHW_SEM2;
}

void dsp_wait_auth(void) 
{
    *HW_SEM2 = 0;   
    *HW_SEM2 = 1;   

	*HW_SEM0 = 0;
    *HW_SEM0 = 1;

	*HW_SEM1 = 0;
}


