//-----------------------------------------------------------------------------
//
//  Copyright 2002 Philips Semiconductors Limited
//
//  Philips Semiconductors - Millbrook Industrial Estate
//  Southampton - SO15 0DJ - UK
//
//  All rights are reserved. Reproduction in whole or part is prohibited
//  without the written prior consent of the copyright owner.
//
//  Company Confidential
//
//  Filename: mont.h
//  Project: Centaurus2 / Tamperproof
//
//  Rev		Date		Author		Comments
//  -------------------------------------------------------------------
//  001		05/12/2002	A.Badey		Original version for Centaurus2
//  002		25/11/2008	T. Mowle	Remove global vars - restrict to 2k keys
//
//  Additionnal information:
//  This code is based on the mont.h code by Bruce Murray. Refer to this code
//  for more information on the revisions made.
//
//  Function:
//  This module is the header module for bn.o1.c.
//
//----------------------------------------------------------------------------- 

#ifndef  _BN_H_
#define  _BN_H_

//------------------
// INCLUDE FILES
//------------------

//------------------
// EXPORTED MACRO
//------------------

// Define the size of a 'BIGNUM' in multiples of 'u32's
// Edit this value to match the size of the modulus.

#define U32s_PER_BIGNUM 64
#define U32s_PER_1KBITS 32

#define BYTES_PER_BIGNUM (U32s_PER_BIGNUM * 4)
#define BYTES_PER_1KBITS (U32s_PER_1KBITS * 4)

#define BITS_PER_BIGNUM (U32s_PER_BIGNUM * 32)
#define BITS_PER_1KBITS (U32s_PER_1KBITS * 32)
 
//--------------------
// EXPORTED TYPEDEFS
//--------------------

// Structure for BITS_IN_Bignum_t -bit big number
// slice[0] = least significant slice
typedef struct
{
   unsigned long slice[U32s_PER_BIGNUM];
}
Bignum_t;

//--------------------
// EXPORTED DATA
//--------------------

/*
unsigned long u32s_per_bignum;
unsigned long bits_per_bignum;
unsigned long endian;
*/

#define u32s_per_bignum	U32s_PER_BIGNUM
// Wrong #define bits_per_bignum U32s_PER_1KBITS
#define bits_per_bignum BITS_PER_BIGNUM

//--------------------
// FUNCTION PROTOTYPES
//--------------------
#ifdef REMOVE_MEMCPY
void BnCpy (unsigned long *to, unsigned long *from);
#endif

// BnMake(bignum to init, long unsigned number)
// ->Set up a Bignum_t from a 32-bit unsigned number.
void BnMake 	 ( Bignum_t *, unsigned int);

// BnNumDigits(bignum)
// ->Determines num of significant digits (slices) in the Bignum_t
int  BnNumDigits ( Bignum_t *);

// BnCmp(first bignum, second bignum)
// ->Compare two Bignum
int  BnCmp  	 ( Bignum_t *, Bignum_t *);

// BnCmpSwapped(first bignum, second bignum)
// ->Compare two Bignum with swapped word orders
int  BnCmpSwapped  	 ( Bignum_t *, Bignum_t *);

// BnAcc(1st operand/result, 2nd operand)
// ->Adds two Bignum_ts with carry; p += q;
int  BnAcc  	 ( Bignum_t *, Bignum_t *);

// BnDec(1st operand/result, 2nd operand)
// ->Subtracts with borrow a Bignum_t from another: p -=q
int  BnDec  	 ( Bignum_t *, Bignum_t *);

// BnTestBit(bignum, position of bit to test)
// ->Test a bit in a Bignum_t
unsigned int BnTestBit ( Bignum_t *, int );

// BnASL(result, input)
// ->performs a 1 bit shift left function on Bignum
unsigned int BnASL     ( Bignum_t *, Bignum_t *);

// Omura(result, top boundary)
// ->Compute the Omura correction associated with a number m.
void Omura  	 ( Bignum_t *, Bignum_t *);

// BnNumBitsIn(Bignum)
// ->Compute the number of significant bits in a Bignum_t.
int  BnNumBitsIn ( Bignum_t *);


#endif // _BN_H      Do not add anything below this line


