/*
 *  Copyright(C) 2008 NXP Semiconductor N.V.,
 *  All Rights Reserved.
 *  This  source code and any compilation or derivative thereof is the
 *  proprietary information of Koninklijke Philips Electronics N.V.
 *  and is confidential in nature.
 *  Under no circumstances is this software to be exposed to or placed
 *  under an Open Source License of any type without the expressed
 *  written permission of Koninklijke Philips Electronics N.V.
 *
 */

/*============================================================================*
 * Standard include files:
 *============================================================================*/


/*============================================================================*
 * Project include files:
 *============================================================================*/

#include "wrapper.h"
#include "./sha256.h"
#include "auth_msg.h"

#include <linux/lzo.h>
#include "../lib_generic/lzo/lzodefs.h"

#if 0
static SHA256 sha; 
#endif

struct lzo_info {
	unsigned char magic[8];
	unsigned int  flags;       	/* donot compute a checksum */
	unsigned char method;      	/* compression method: LZO1X */
	unsigned char level;		/* compression level */
	unsigned int  block_size;
	unsigned int  last_block;	/* size of the last compression block */
	unsigned int  total_blocks;	/* size of the last compression block */
	unsigned int  checksum;
};

static struct lzo_info lzoheader;
static unsigned int  sz_compr[1024];
static unsigned char *puncompressed = NULL;

#define IN_LEN 		(BLOCK_SIZE)
#define OUT_LEN     ROUND_UP((IN_LEN + IN_LEN / 16 + 64 + 3), 0x80)

static unsigned char indata[OUT_LEN ];
unsigned int   count  = 0;
unsigned int   left  = 0;

/* magic file header for lzopack-compressed files */
static const unsigned char magic[8] =
    { 0x00, 0xe9, 0x4c, 0x5a, 0x4f, 0xff, 0x1a, 0x00 };

#ifdef MYDEBUG
static void show_lzo_header(struct lzo_info *pheader);
#else
#define show_lzo_header(ph)
#endif

static int lzo_decompress_init(
	struct lzo_info *lzohdr, 
	unsigned int *psz,
	unsigned char *startaddr,
	int *plen);
static int lzo_decompress_block(unsigned char *pinput, unsigned int size);

int lzo_dispatch(void *pdata, long size, int action, int do_auth)
{
    volatile unsigned long  *memory;
    unsigned char 			*cp;
    unsigned long           ts;
	int 					len = 0;
	static int				lzo_initialised = 0;
	static unsigned char 	*startaddr = NULL;	
	static int				tocopy = 0;
	
    /* Continue with the authentication process until the MIPS signals to stop */
    memory  = (unsigned long *)pdata;

	if (action==AUTH_SHA_NEXT) {
		// if lzo_initialised is false, action would be AUTH_LZO_FIRST
		action = action + !lzo_initialised;
	}
		
	/* Take a snapshot so the time spent authenticating can be measured */
    //ts = *TSU_REG;

   switch (action)
   {

#if 0
   case AUTH_SHA_FIRST:
   		myinfo("===>AUTH_SHA_FIRST\n");
		{
			int i;
			for (i=0; i<8; i++) 
				bis_hash[i] = 0;
		}
					
		sha256_begin(&sha);
		sha256_next (&sha, (unsigned long *)memory, size);
		break;
#endif

	case AUTH_LZO_INIT:
		myinfo("===>AUTH_LZO_INIT\n");
		
		startaddr = (unsigned char *)memory;
		mydebug("AUTH_LZO_INIT startaddr=%08lx\n", startaddr);
		
		lzo_initialised = 0;
		count = 0;	
		left = 0;
		puncompressed = NULL;

		tocopy = 0;
		break;
		
	case AUTH_LZO_FIRST:
		myinfo("===>AUTH_LZO_FIRST\n");

		// Process Lzo information block
		// Lzo info + out_len array			
		cp = (unsigned char *)memory;
		lzo_decompress_init( (struct lzo_info*)cp, 
							  (unsigned int *)(cp + sizeof(struct lzo_info)),
							  startaddr, &len);
		
		cp += len;
		if (size > len) {
			lzo_decompress_block(cp, size - len);
		}

		lzo_initialised = 1;
		break;

    case AUTH_SHA_NEXT:
		myinfo("===>AUTH_SHA_NEXT\n");

		cp = (unsigned char *)memory;
		// First process the data left for the last time
		if (left > 0) {
			unsigned int in_len;
			
			in_len = sz_compr[count];			
			tocopy = in_len - left;
			
			mydebug("tocopy=%x left=%x in_len=%x\n", tocopy, left, in_len);
			if ( (tocopy>0) && (tocopy <= size) ) {
				memcpy(indata+left, cp, tocopy);

				left += tocopy;
				mydebug("==>check: left(%x) should be equal to in_len(%x)\n", left, in_len);

				lzo_decompress_block(indata, in_len);
				cp += tocopy;
				mydebug("==>check: left(%x) should be 0\n", left);
			} else {
				printf("Corrupted data\n");
			}
		}

		if (size - tocopy > 0) {
			lzo_decompress_block(cp, size - tocopy);
		}
		break;
        
    case AUTH_SHA_LAST:
   		myinfo("===>AUTH_SHA_LAST\n");			
		cp = (unsigned char *)memory;
		// First process the data left for the last time
		if (left > 0) {
			unsigned int in_len;
			
			in_len = sz_compr[count];			
			tocopy = in_len - left;
			
			mydebug("tocopy=%x left=%x in_len=%x\n", tocopy, left, in_len);
			if ( (tocopy>0) && (tocopy <= size) ) {
				memcpy(indata+left, cp, tocopy);

				left += tocopy;
				mydebug("==>check: left(%x) should be equal to in_len(%x)\n", left, in_len);

				lzo_decompress_block(indata, in_len);
				cp += tocopy;
				mydebug("==>check: left(%x) should be 0\n", left);
			} else {
				printf("Corrupted data\n");
			}
		}

		if (size - tocopy > 0) {
			lzo_decompress_block(cp, size - tocopy);
		}
		break;

    case AUTH_SHA_GOODBYE:        	
   		myinfo("===>AUTH_SHA_GOODBYE\n");			

		/* Time to say goodbye */
		startaddr = NULL;
        break;
    }

	return 0;
}

static int lzo_decompress_init(
	struct lzo_info *lzohdr, 
	unsigned int  *psz,
	unsigned char *startaddr,
	int *plen)
{
	int r;
	
	memcpy(&lzoheader, lzohdr, sizeof(struct lzo_info));
	show_lzo_header(&lzoheader);

	memcpy(sz_compr, psz, lzoheader.total_blocks * 4);

#ifdef MYDEBUG
	{
		int i;
		for (i=0; i<lzoheader.total_blocks; i++) {
			printf("sz_compr[%d]=%x (%d)\n", i, sz_compr[i], sz_compr[i]);
		}
	}
#endif

	puncompressed = startaddr;
	mydebug("puncompressed = %08x\n", (unsigned int)puncompressed);

	/* lzo_init() is a macro to allow checking that the library and the
	 * compiler's view of various types are consistent.
	 * We assume it's ok with mips... so skip the check here.
	 */
#if 0
	if (lzo_init() != LZO_E_OK)
	{
	  printf("internal error - lzo_init() failed !!!\n");
	  printf("(this usually indicates a compiler bug - try recompiling\nwithout optimizations, and enable `-DLZO_DEBUG' for diagnostics)\n");
	  return(-1);
	}
#endif	

/*
 * Step 1: check magic header, read flags & block size, init checksum
 */
	if (memcmp(magic, lzoheader.magic, sizeof(lzoheader.magic)) != 0)
	{
		printf("Header error - this file is not compressed by lzopack\n");
		r = 1;
		return(r);
	}
		
	if (lzoheader.method != 1)
	{
		printf("Header error - invalid method %d (level %d)\n",
				lzoheader.method, lzoheader.level);
		r = 2;
		return(r);
	}

	if (lzoheader.block_size < 1024 || lzoheader.block_size > 8*1024*1024L)
	{
		printf("header error - invalid block size %ld\n", (long) lzoheader.block_size);
		r = 3;
		return(r);
	}

	*plen = sizeof(struct lzo_info) + lzoheader.total_blocks*4;
	return 0;
}

static int lzo_decompress_block(unsigned char *pinput, unsigned int size)
{
#if 0
	lzo_bytep in;
	lzo_bytep out;
	lzo_uint in_len;
	lzo_uint out_len;
#endif
	unsigned char *in;
	unsigned char *out;
	unsigned int   in_len;
	unsigned int   out_len;

	int r;
	unsigned char *pwa = pinput;
	unsigned int avail = size;


	myinfo("enter\n");
	
/*
 * Step 3: process blocks
 */
	// Now it should operate on the input memory directly
    for (;;) 
    {

		if (count >= lzoheader.total_blocks) {
			memcpy(puncompressed, pwa, avail);
			return 0;
		}

        /* read uncompressed size */
		out_len = lzoheader.block_size;
		
		// The last block may have a different length.
		if ( (count==(lzoheader.total_blocks-1)) && (lzoheader.last_block > 0) ){
			out_len = lzoheader.last_block;
		}
		
        /* read compressed size */
		in_len = sz_compr[count];

		mydebug("avail=%x in_len=%x\n", avail, in_len);
		if (avail< in_len) {
			memcpy(indata, pwa, avail);
			left = avail;
			break;
		}
		
        /* sanity check of the size values */
        if (in_len > lzoheader.block_size || out_len > lzoheader.block_size ||
            in_len == 0 || in_len > out_len)
        {
            printf("Block size error - data corrupted\n");
            r = 5;
            goto err;
        }

        /* place compressed block at the top of the buffer */
		in  = pwa;
		out = puncompressed;
		
        /* read compressed block data */
        if (in_len < out_len)
        {
            /* decompress - use safe decompressor as data might be corrupted
             * during a file transfer */
            //lzo_uint new_len = out_len;
            unsigned int new_len = out_len;
		
            // r = lzo1x_decompress(in, in_len, out, &new_len, NULL);			
			myinfo("going to call lzo1x_decompress_safe()\n");
			r = lzo1x_decompress_safe(in, in_len, out, &new_len);
			mydebug("lzo1x_decompress_safe returns %d\n", r);

            if (r != LZO_E_OK || new_len != out_len)
            {
                printf("compressed data violation, r=%d new_len=%x out_len=%x\n",
					r, new_len, out_len);
                r = 6;
                goto err;
            }
            /* write decompressed block */
            //tmCacheDataCopyBack(puncompressed, out_len);
			puncompressed += out_len;
		}
        else
        {
            /* write original (incompressible) block */
			puncompressed += in_len;
        }

		//*bis_datasize += in_len;
		pwa   += in_len;		
		avail -= in_len;
		count++;
    }

    r = 0;
	
err:
    return r;
}

#ifdef MYDEBUG
static void show_lzo_header(struct lzo_info *pheader)
{
	int i;

	printf("LZO header information:\n");
	for (i=0; i<sizeof(pheader->magic); i++) 
	{
		printf("%02x ", pheader->magic[i]);
	}
	printf("\n");

	printf("\tflags        = %x\n", pheader->flags);	
	printf("\tlevel        = %x\n", pheader->level);  
	printf("\tmethod       = %x\n", pheader->method);
	printf("\tblock_size   = %x\n", pheader->block_size);
	printf("\tlast_block   = %x\n", pheader->last_block);
	printf("\ttotal_blocks = %x\n", pheader->total_blocks);
	printf("\tchecksum     = %x\n", pheader->checksum);
}
#endif

