//#define MMIO(x)         (0xbbe00000+(x))
#define MMIO(x)         (MMIO_BASE + (x))

typedef unsigned long BignumInt;
typedef unsigned long long BignumDblInt;
typedef BignumInt *Bignum;

//#define U32s_PER_BIGNUM 32
#define U32s_PER_BIGNUM 64
#define U32s_PER_1KBITS 32

#define BYTES_PER_BIGNUM (U32s_PER_BIGNUM * 4)
#define BYTES_PER_1KBITS (U32s_PER_1KBITS * 4)

#define BITS_PER_BIGNUM (U32s_PER_BIGNUM * 32)
#define BITS_PER_1KBITS (U32s_PER_1KBITS * 32)

#define Bignum_t     unsigned int   /* always referenced as a pointer first word is least significant */

#define BIG0   0
#define BIG0E  BYTES_PER_BIGNUM
#define BIG1   (BYTES_PER_BIGNUM*2)
#define BIG2   (BYTES_PER_BIGNUM*3)
#define BIG3   (BYTES_PER_BIGNUM*4)
#define BIG4   (BYTES_PER_BIGNUM*5)
#define BIG5   (BYTES_PER_BIGNUM*6)
#define BIG6   (BYTES_PER_BIGNUM*7)

typedef struct
{
   unsigned int modulus[U32s_PER_BIGNUM]; /* as defined in key */
   unsigned int exponent;                 /* as defined in key */
   unsigned long workarea;                /* address of a work area */
}rsa_info;  

int rsa_decode(Bignum_t *OutputBlock, Bignum_t *InputBlock, rsa_info *info);
