//
//  NXP Semiconductors - Millbrook Industrial Estate
//  Southampton - SO15 0DJ - UK
//
//  All rights are reserved. Reproduction in whole or part is prohibited
//  without the written prior consent of the copyright owner.
//
//  Company Confidential
//
//  Filename: sha256.h
//  Project: PNX85500
//
//  Rev		Date		Author		Comments
//  -------------------------------------------------------------------
//  001	08/11/2008	    F.Dada	    Based on "nagra_derivation.c" (PNX8335)
//
//  Additional information:
//
//  Function:
//  This module implements the SHA-256 algorithm as defined in the specification
//  for the Secure Hash Standard (FIPS PUB 180-2 - US National Institute of 
//  Standards and Technology). 
//
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Function: sha256
//
// Description: performs the sha256 core computation as described in fips180_2
//              for a message whose length is an integer multiple(n) of 512 bits
//
// Input 1: pointer to the 512*n bits message as 16 unsigned long (32 bits) words
// Input 2: size of the input message to be hashed (i.e. number of 32-bit words)
// Output : pointer to the 256 bits hash result as 8 unsigned long words
//-----------------------------------------------------------------------------

#ifndef  _SHA256_H_
#define  _SHA256_H_

#include <common.h>

typedef unsigned long long uint64;
//typedef unsigned long ulong;
//typedef unsigned char uchar;

//	private structure for SHA
//  move to header file
typedef struct {
	uchar buff[512/8];	// buffer, digest when full
	ulong h[256/32];	// state variable of digest
	uint64 length;		// number of bytes in digest
	int next;			// next buffer available
} SHA256;

#ifndef CONFIG_TV55X
extern void sha256_begin (SHA256 *sha);
extern void sha256_next (SHA256 *sha, uchar *what, int len);
extern void sha256_finish (SHA256 *sha, ulong *out);
#endif

#endif


