
/*============================================================================*
 * Standard include files:
 *============================================================================*/


/*============================================================================*
 * Project include files:
 *============================================================================*/

#include "zlib.h"

#include "wrapper.h"
#include "bn.h"

#include "tdfloader_local.h"
#include "tdfloader.h"
#include "auth.h"

#include <asm/io.h>

#if 0
#define TSU_REG         ((volatile unsigned int*)(MMIO_BASE + 0x14c0c0)))
#endif

/*============================================================================*
 * Types and defines:
 *============================================================================*/

#define TDF_PLAIN               0
#define TDF_SIGNED              1
#define TDF_COMPRESSED          2
#define TDF_SIGNED_COMPRESSED   3
#define TDF_PLAIN_1             4

/*============================================================================*
 * Global data:
 *============================================================================*/

/*============================================================================*
 * Static variables:
 *============================================================================*/

#define offset_payload_hdr          (sizeof(TdfHeader_t))
#define offset_signed_payload_hdr   (sizeof(TdfHeader_t) + sizeof(TdfPayloadHeader_t))
#define offset_content_payload_hdr  (sizeof(TdfHeader_t) + sizeof(TdfPayloadHeader_t) + PADDINGSIZE(sizeof(TdfHeader_t) + sizeof(TdfPayloadHeader_t), 64))

static char TdfHeader[ sizeof(TdfHeader_t) 
                     + sizeof(TdfPayloadHeader_t) 
                     + sizeof(TdfSignedPayload_t)
                     + (3 * DCACHE_BYTES_PER_LINE)
                     ];

static char TdfSign  [ (4 + (U32s_PER_BIGNUM * 4))
                     + (3 * DCACHE_BYTES_PER_LINE)
                     ];

const TdfVersion_t TdfVersions [] =
{
    TDF_VERSION_3,
    TDF_VERSION_2,
    TDF_VERSION_1,
    TDF_VERSION_UNKNOWN,
};

const TdfCpuType_t TdfCpuTypes [] =
{
    { TDF_CPU_TYPE_MIPS_PR4450,         "PR4450"  },
    { TDF_CPU_TYPE_TM_1500,             "TM1500" },
    { TDF_CPU_TYPE_UNKNOWN,             "unknown" },
};

const TdfFileType_t TdfFileTypes [] =
{
    { TDF_FILE_TYPE_TEXT,               "Text"     },
    { TDF_FILE_TYPE_DATA,               "Data"     },
    { TDF_FILE_TYPE_TEXT_AND_DATA,      "TextDat"  },
    { TDF_FILE_TYPE_UNKNOWN,            "unknown"  },
};

const TdfCompression_t TdfCompressions [] =
{
    { TDF_FILE_COMPRESSION_NONE,        "None"     },
#if defined(AUTHTDFLOADER_FULL)
    { TDF_FILE_COMPRESSION_ZLIB,        "ZLib"     },
#endif    
    { TDF_FILE_COMPRESSION_UNKNOWN,     "unknown"  },
};

const TdfCheck_t TdfChecks [] =
{
    { TDF_FILE_CHECK_CRC16,             "CRC16"    },
//#if defined(TDFLOADER_FULL)
    { TDF_FILE_CHECK_ADLER32,           "Adler32"  },
//#endif    
    { TDF_FILE_CHECK_UNKNOWN,           "unknown"  },
};

struct lzo_info {
	unsigned char magic[7];
	unsigned int  flags;       	/* donot compute a checksum */
	unsigned char method;      	/* compression method: LZO1X */
	unsigned char level;		/* compression level */
	unsigned int  block_size;
	unsigned int  last_block;	/* size of the last compression block */
	unsigned int  total_blocks;	/* size of the last compression block */
	unsigned int  checksum;
};

//static unsigned char pCompData[COMP_BLOCK_SIZE] __attribute__ ((aligned (2 * DCACHE_BYTES_PER_LINE)));
//static unsigned char compData[2][COMP_BLOCK_SIZE + DCACHE_BYTES_PER_LINE] __attribute__ ((aligned (2 * DCACHE_BYTES_PER_LINE)));
//Align on avdsp cache line
static unsigned char compData[2][COMP_BLOCK_SIZE] __attribute__ ((aligned (0x80)));
static unsigned char *pCompData;

/*============================================================================*
 * Internal prototypes
 *============================================================================*/
static int ReadPlainSignedTDF(  void* pFile, TdfHeader_t *hdr, TdfPayloadHeader_t *pld, 
                                        unsigned long *sig, unsigned char *startaddr);

#if 0
static int ReadCompressedSignedTDF(void *pFile, TdfHeader_t *hdr, 
	TdfPayloadHeader_t *pld, TdfPayloadHeader_t *pld1, unsigned long *sig, unsigned char *startaddr);
#endif

static int ReadLzoCompressedSignedTDF(void *pFile, TdfHeader_t *hdr,
	TdfPayloadHeader_t *pld, TdfPayloadHeader_t *pld1,unsigned long *sig,unsigned char *startaddr);


//YW: only needed for zlib
#if 0
// Utility functions

voidpf 
zcalloc (voidpf   opaque, 
     unsigned items, 
     unsigned size)
{
  void *x = malloc( items * size );
  //printf("malloc:%08x\n", x);
  return x;
}

void  
zcfree (voidpf opaque, 
        voidpf ptr )
{
   //printf("free:%08x\n", ptr);
   free( ptr );
}
#endif

/*============================================================================*
 * External functions
 *============================================================================*/

/******************************************************************************
 * FUNCTION: <Function Name>
 ******************************************************************************/
unsigned int tmbtAuthTdfLoader_Load(char* fname, void *startaddr)
{
    unsigned int             tmRetVal    = 0;
    unsigned int             tmRetVal2   = 0;
    void                    *fp = NULL;             // for now, just a palce holder
    TdfHeader_t             *pTdfHeader         = (TdfHeader_t*)(((unsigned int)TdfHeader   + ((2 * DCACHE_BYTES_PER_LINE) - 1)) & ~((2*DCACHE_BYTES_PER_LINE) - 1));
    unsigned long           *pTdfSign           = (unsigned long *)(((unsigned int)TdfSign  + ((2 * DCACHE_BYTES_PER_LINE) - 1)) & ~((2*DCACHE_BYTES_PER_LINE) - 1));
    TdfPayloadHeader_t      *pTdfPayload        = (TdfPayloadHeader_t *)((unsigned long)pTdfHeader + offset_payload_hdr);
    TdfSignedPayload_t      *pTdfSignedPayload  = (TdfSignedPayload_t *)((unsigned long)pTdfHeader + offset_signed_payload_hdr);
    TdfPayloadHeader_t      *pTdfContentPayload = (TdfPayloadHeader_t *)((unsigned long)pTdfHeader + offset_content_payload_hdr);
    unsigned long           count;
    //unsigned long           compressionType;
    unsigned long           offset = 0;
    unsigned long           bytes = 0;

    /*
    **  Ok started to use goto to handle exceptions. Was fighting this for some time but feel
    **  it would in the end make the code more readable. Have some very well know people on
    **  my side so I don't feel bad about make this change.
    */
    mydebug("fname=%s startaddr:%lx\n", fname, (unsigned long)startaddr);
        
    /* Outside world might need this info as well lets provide it */
    //*tdfHeader = pTdfHeader;

    // fat fs is read-only
    fp = fopen(fname, NULL); 
    if (fp==NULL) 
    {
        printf("\n\tError: Cannot open %s\n", fname);
        tmRetVal = TMDL_ERR_TDF_INVALID_FILE;
        goto tmbtAuthTdfLoader_file_error;
    }
 
    /* 
    **  Fetch the TDF header first
    */
    count = sizeof(TdfHeader_t);
    mydebug("Read TdfHeader, offset=0x%lx (%ld) count=0x%lx (%ld)\n", offset, offset, count, count);
    bytes = fread((void *)pTdfHeader, count, 1, fp);
    if (bytes == 0) 
    {
        tmRetVal = TMDL_ERR_TDF_INVALID_FORMAT;
        goto tmbtAuthTdfLoader_file_error;
    }
    offset += count;
    ShowTTDFHeader(pTdfHeader);
    
    /*
    **  Was the complete header fetched from the file
    */
    if (count != sizeof(TdfHeader_t)) 
    {
        tmRetVal = TMDL_ERR_TDF_INVALID_FORMAT;
        goto tmbtAuthTdfLoader_file_error;
    }

    tmRetVal = tmbtAuthTdfLoader_HeaderValidate(pTdfHeader);
    if (tmRetVal != 0) 
    {
        mydebug("!!!! tmbtAuthTdfLoader_HeaderValidate returns %d\n", tmRetVal);
        goto tmbtAuthTdfLoader_file_error;
    }

    /*
    **  Only version 2 TDF file are supported, check this
    */
    if (pTdfHeader->TdfVersion != TDF_VERSION_3)
    { 
        tmRetVal = TMDL_ERR_TDF_INVALID_FORMAT;
        goto tmbtAuthTdfLoader_file_error;
    }

    /*
    **  Read the first payload header it will tell the kind on payload the TDF file contains
    */
    count = sizeof(TdfPayloadHeader_t);
    mydebug("Read TdfPayload, offset=0x%lx (%ld) count=0x%lx (%ld)\n", offset, offset, count, count);
    bytes = fread((void *)pTdfPayload, count, 1, fp);
    if (bytes != count)
    {
        tmRetVal = TMDL_ERR_TDF_INVALID_FORMAT;
        goto tmbtAuthTdfLoader_file_error;
    }
    offset += count;
    ShowTTDFPayloadHeader(pTdfPayload);
            
    /*
    **  Has to be a signed TDF. Should bail out if it something different
    */
    if (pTdfPayload->payloadType != TDF_PL_SIGNING_SHA256)
    {
        tmRetVal = TMDL_ERR_TDF_INVALID_FORMAT;
        goto tmbtAuthTdfLoader_file_error;
    }

    /*
    **  Take care of the padding bytes
    */
    count = PADDINGSIZE(sizeof(TdfHeader_t) + sizeof(TdfPayloadHeader_t), 64);
    mydebug("Read TdfSignPayloadPadding, offset=0x%lx (%ld) count=0x%lx (%ld)\n", offset, offset, count, count);                                
    bytes = fread((void *)pTdfSignedPayload, count, 1, fp);
    if (bytes != count)
    {
        tmRetVal = TMDL_ERR_TDF_AUTH_UNKNOWN;
        goto tmbtAuthTdfLoader_file_error;
    }
    offset += count;

    /* 
    **  Don't bother about caching right now Authentication function will take care 
    **  of this.
    */

    /*
    **  Now get the signature from the SignedPayload
    */
    count = 256;
    mydebug("Read Signature, offset=0x%lx (%ld) count=0x%lx (%ld)\n", offset, offset, count, count);                                
    bytes = fread((void *)(pTdfSign), count, 1, fp);
    if (bytes != count)
    {
        tmRetVal = TMDL_ERR_TDF_AUTH_UNKNOWN;
        goto tmbtAuthTdfLoader_file_error;
    }
    offset += count;
    myinfo("\n");
    dump("RSA 256 sig LE", (unsigned char *)pTdfSign, 256);
    //DCacheIndexWritebackInvalidate();
    //YW: to check
    //invalidate_dcache_range(pTdfSign, 256);
    myinfo("\n");
    
    if (count != 256)
    {   
        tmRetVal = TMDL_ERR_TDF_INVALID_FORMAT;
        goto tmbtAuthTdfLoader_file_error;
    }

    /*
    **  Read the next payload header it will tell if the TDF file contains
    */
    count = sizeof(TdfPayloadHeader_t);
    mydebug("Read TdfPayloadHeader, offset=0x%lx (%ld) count=0x%lx (%ld)\n", offset, offset, count, count);                                
    bytes = fread((void *)pTdfContentPayload, count, 1, fp);
    if (bytes != count)
    {
        tmRetVal = TMDL_ERR_TDF_INVALID_FORMAT;
        goto tmbtAuthTdfLoader_file_error;
    }
    offset += count;
    ShowTTDFPayloadHeader(pTdfContentPayload);
    //DCacheIndexWritebackInvalidate();
    //invalidate_dcache_range(pTdfContentPayload, sizeof(*pTdfContentPayload));
    
    /*
    **  Hash the TDF headers
    */
    count =  sizeof(TdfHeader_t);
    count += sizeof(TdfPayloadHeader_t);
    count += PADDINGSIZE(sizeof(TdfHeader_t) + sizeof(TdfPayloadHeader_t), 64);
    count += sizeof(TdfPayloadHeader_t);
    mydebug("offset=0x%lx (%ld)\n", offset, offset);
    mydebug("going to call tmbtAuth_Dispatch(), count=0x%lx (%ld)\n", count, count);
    tmbtAuth_Dispatch(pTdfHeader, count, AUTH_SHA_FIRST, 1);

    mydebug("....offset: 0x%lx (%ld)\n", offset, offset);
    if (pTdfContentPayload->payloadType == TDF_PL_PLAIN)
    {
        /*  TDF version 3, none compressed, signed      */
        myinfo("going to call ReadPlainSignedTDF()\n");
        //tmRetVal = ReadPlainSignedTDF(NULL, pTdfHeader, pTdfPayload, pTdfSign);
        tmRetVal = ReadPlainSignedTDF(NULL, pTdfHeader, pTdfPayload, pTdfSign, startaddr);
    }
    else if (pTdfContentPayload->payloadType == TDF_PL_COMPRESS_ZLIB)
    {
#if 0
        /*  TDF version 3, compressed, signed           */
        myinfo(">> ReadCompressedSignedTDF\n");
        tmRetVal = ReadCompressedSignedTDF(NULL, pTdfHeader, pTdfContentPayload, pTdfPayload, pTdfSign, startaddr);
#endif
		puts("Error: zlib is not supported. Please use plain or lzo compressed images.\n");
        tmRetVal = TMDL_ERR_TDF_INVALID_FORMAT;
    }
    else if (pTdfContentPayload->payloadType == TDF_PL_COMPRESS_LZO)
    {
        /*  TDF version 3, compressed, signed           */
        myinfo(">> ReadLzoCompressedSignedTDF\n");
        tmRetVal = ReadLzoCompressedSignedTDF(NULL, pTdfHeader, pTdfContentPayload, pTdfPayload, pTdfSign, startaddr);
    }
    else
    {     
        myinfo("!!!!!! TMDL_ERR_TDF_INVALID_FORMAT\n");
        tmRetVal = TMDL_ERR_TDF_INVALID_FORMAT;
    }

tmbtAuthTdfLoader_file_error:
    return ( tmRetVal != 0) ? tmRetVal : tmRetVal2;    
}

/******************************************************************************
 * FUNCTION: <Function Name>
 ******************************************************************************/

unsigned int tmbtAuthTdfLoader_HeaderValidate(void *pth)
{
    register unsigned int           tmRetVal = 0;
    register const TdfVersion_t     *pTdfVersion;
    register const TdfCpuType_t     *pTdfCpuType;
    register const TdfFileType_t    *pTdfFileType;
    register const TdfCompression_t *pTdfCompression;
    register const TdfCheck_t       *pTdfCheck;
    unsigned long                   fileType, compressionType, checkType;
    register TdfHeader_t            *pTdfHeader;
    
    pTdfHeader = pth;

    /* Only check header magic, header is depend on the TDF version used */
    if ( pTdfHeader->Magic != TDF_HEADER_MAGIC)
    {
        tmRetVal = TMDL_ERR_TDF_INVALID_FORMAT;
    }
    else
    {    
        // tdf version
        for ( pTdfVersion = TdfVersions;
              *pTdfVersion != pTdfHeader->TdfVersion && *pTdfVersion != TDF_VERSION_UNKNOWN;
              pTdfVersion++ ) {
            mydebug("check version: pTdfVersion:%d\n", *pTdfVersion);
        }
              
        if ( *pTdfVersion == TDF_VERSION_UNKNOWN ) 
        {
            tmRetVal = TMDL_ERR_TDF_TDF_VERSION_UNKNOWN;
            myinfo("TMDL_ERR_TDF_TDF_VERSION_UNKNOWN");
        }
        else
        {
            // cpu type
            for ( pTdfCpuType = TdfCpuTypes; 
                  pTdfCpuType->Type != pTdfHeader->CpuType && pTdfCpuType->Type != TDF_CPU_TYPE_UNKNOWN;
                  pTdfCpuType++ );
                  
            if ( pTdfCpuType->Type == TDF_CPU_TYPE_UNKNOWN ) 
            {
                tmRetVal = TMDL_ERR_TDF_CPU_TYPE_UNKNOWN;
                myinfo("TMDL_ERR_TDF_CPU_TYPE_UNKNOWN");
            }
            else
            {
                // file type
                fileType = pTdfHeader->FileType & TDF_FILE_TYPE_MASK;
                for ( pTdfFileType = TdfFileTypes; 
                      pTdfFileType->Type != fileType && pTdfFileType->Type != TDF_FILE_TYPE_UNKNOWN;
                      pTdfFileType++ );
                      
                if ( pTdfFileType->Type == TDF_FILE_TYPE_UNKNOWN ) 
                {
                    tmRetVal = TMDL_ERR_TDF_FILE_TYPE_UNKNOWN;
                    myinfo("TMDL_ERR_TDF_FILE_TYPE_UNKNOWN");
 
                }
                else
                {
                    // compression type
                    compressionType = pTdfHeader->FileType & TDF_FILE_COMPRESSION_MASK;
                    for ( pTdfCompression = TdfCompressions;
                          pTdfCompression->Compression != compressionType && pTdfCompression->Compression != TDF_FILE_COMPRESSION_UNKNOWN;
                          pTdfCompression++ );
                          
                    if ( pTdfCompression->Compression == TDF_FILE_COMPRESSION_UNKNOWN )
                    {
                        tmRetVal = TMDL_ERR_TDF_COMPRESSION_UNKNOWN;
                        myinfo("TMDL_ERR_TDF_COMPRESSION_UNKNOWN");
                    }
                    else
                    {
                        // check type
                        checkType = pTdfHeader->FileType & TDF_FILE_CHECK_MASK;
                        for ( pTdfCheck = TdfChecks;
                              pTdfCheck->Check != checkType && pTdfCheck->Check != TDF_FILE_CHECK_UNKNOWN;
                              pTdfCheck++ );
                              
                        if ( pTdfCheck->Check == TDF_FILE_CHECK_UNKNOWN )
                        {                    
                            tmRetVal = TMDL_ERR_TDF_CHECK_UNKNOWN;
                            myinfo("TMDL_ERR_TDF_CHECK_UNKNOWN");
                        }
                    }
                }
            }
        }        
    }

    return tmRetVal;    
}    

static int ReadPlainSignedTDF(  void* pFile, TdfHeader_t *hdr, TdfPayloadHeader_t *pld, 
                                        unsigned long *sig, unsigned char *startaddr)
{
    unsigned int        tmRetVal = 0;
    unsigned long        count;
    unsigned char       *pData = 0L;
    int                 action;
    unsigned long       bucket;
    int                 done  = 0;
    int                 state = 0;

#define _START          0
#define _INIT_READ      1
#define _NEXT_READ      2
#define _AUTHENTICATE   3

    while (!done)
    {
        switch (state)
        {
        case _START:
            state = _NEXT_READ;
        case _INIT_READ:
            /*
            **  Continue with authenticating the "real" data content
            */
            pData = startaddr;
            count = pld->payloadSize - sizeof(TdfSignedPayload_t) - sizeof(TdfPayloadHeader_t);
            
            mydebug("pld->payloadSize: 0x%lx (%ld)\n", 
                pld->payloadSize, pld->payloadSize);
            mydebug("sizeof(TdfSignedPayload_t): 0x%x (%d)\n", 
                sizeof(TdfSignedPayload_t), sizeof(TdfSignedPayload_t));
            mydebug("sizeof(TdfPayloadHeader_t): 0x%x (%d)\n", 
                sizeof(TdfPayloadHeader_t), sizeof(TdfPayloadHeader_t));

            mydebug("pData=%x count=0x%lx (%ld)\n", (unsigned int)pData, count, count);
            bucket = (count > BUCKET_SZ) ? BUCKET_SZ : count;
            bucket = fread( pData, bucket, 1, NULL);
            mydebug("bucket=0x%lx (%ld)\n", bucket, bucket);

            // Determine the type of action need by the authentication code
#ifdef CONFIG_USE_FAT_FS
            // Due to FAT fopen patch: 1st get the remaining data from buffer
            if ((bucket==count) && (count <= BUCKET_SZ) )
#else
            if (count <= BUCKET_SZ)
#endif
            {   
                // Bucket smaller than .. 
                action = AUTH_SHA_LAST;
                state  = _AUTHENTICATE;
            }
            else
            {
                action = AUTH_SHA_NEXT;
                state  = _NEXT_READ;
            }

            if ( bucket > 0 )
            {
                tmbtAuth_Dispatch(pData, bucket, action, 1);
            }
            else
            {
                puts("--->Read fail....\n"); 
                state = _AUTHENTICATE;
            }
            break;
        case _NEXT_READ:
            // state: SHA_NEXT | SHA_LAST
            count -= bucket;
            pData += bucket;
    
            if (count > (long)BUCKET_SZ)
            {
                action = AUTH_SHA_NEXT;
                state  = _NEXT_READ;
            }
            else
            {
                action = AUTH_SHA_LAST;
                state  = _AUTHENTICATE;
            }

            bucket = (count > BUCKET_SZ) ? BUCKET_SZ : count;
            bucket = fread( pData, bucket, 1, NULL);
            if (bucket > 0)
            {
                tmbtAuth_Dispatch(pData, bucket, action, 1);
            }
            else
            {
                state = _AUTHENTICATE;
            }
            break;
        case _AUTHENTICATE:          
            done  = 1;
            state = _INIT_READ;
            break;
        }
    }   

    if (tmRetVal == 0)
    {
        return tmbtAuth_Compare(sig);
    }
    
    return tmRetVal;
}

//YW: remove zlib decompressing, otherwise the code size is too big.
#if 0
static int ReadCompressedSignedTDF(void *pFile, TdfHeader_t *hdr, TdfPayloadHeader_t *pld, TdfPayloadHeader_t *pld1, unsigned long *sig, unsigned char *startaddr)
{
	unsigned int    tmRetVal = 0;
	long            count, total_count;
	int             err;                             // ZLIB error code (Z_OK is our target)
	z_stream        d_stream;                        // decompression structure
	void*           pDest = startaddr;          // location in RAM (destination of decompression)
	unsigned        leftToReadLen;
	unsigned        thisReadLen;
	int             action, i;
	unsigned        compressedLen;    
	unsigned char   copy[8];                   // copy for the 8 bytes before startaddr

	pCompData = &(compData[0]);

	// compressed payload - direct one block at a time
	total_count = pld1->payloadSize - sizeof(TdfSignedPayload_t) - sizeof(TdfPayloadHeader_t);

	mydebug("@%d: total_count = %d\n", __LINE__, total_count);

	compressedLen = pld->payloadSize;

	mydebug("@%d: compressedLen = %d\n", __LINE__, compressedLen);

	d_stream.zalloc    = (alloc_func)zcalloc;
	d_stream.zfree     = (free_func)zcfree;
	d_stream.opaque    = (voidpf)0;
	d_stream.outcb     = (voidpf)0;
	d_stream.next_in   = pCompData;
	d_stream.avail_in  = 0;

	/* 
	**  The compressed data contains a header. To get the real on the correct spot the
	**  destination needs to be substracted with 8
	*/
	memcpy(copy, startaddr-8, 8);
	d_stream.next_out  = ((unsigned long)pDest) - 8;                

	/* payload size is uncompressed size ! */
	d_stream.avail_out = hdr->ContentSize + 8; 

	/*
	**	Initilize the zip library
	*/
	err = inflateInit(&d_stream);

	if( err != Z_OK ) 
	{
		mydebug("@%d\n", __LINE__);

		tmRetVal = TMDL_ERR_TDF_CRC_INCORRECT;
		goto bail_out;
	}

	/*  
	**  total amount of data we have to read (all the compressed data)
	*/
	leftToReadLen = total_count;                         

	while (1)
	{
		/*
		**  NAND prefetching works best when we just finish a block
		**  at the end of the FileRead (so the prefetch can read the next block
		**  while we do the decompression)
		**  
		**  Empirically, it seems we need to read 2 pages in
		**  the first iteration to reach this magic allignement.
		*/
		thisReadLen = MIN( leftToReadLen, COMP_BLOCK_SIZE ); // size we read this iteration

		/* Wait tm authentication finishes the previous chunk before writing new data
		     if authentication is done by TM.
		*/
		tmbtAuth_wait();

		count = fread( pCompData, thisReadLen, 1, NULL);
	  	total_count -= count;

		mydebug("@%d: count = %d\n", __LINE__, count);
	            
		if (total_count <= 0) {			
			/*
			**	This is the Last Chunk. Finish the SHA256 hashing 
			*/
			tmbtAuth_Dispatch(pCompData, count, AUTH_SHA_LAST, 1);
		} else {
			tmbtAuth_Dispatch(pCompData, count, AUTH_SHA_NEXT, 1);
		}

		d_stream.next_in  = pCompData;
		d_stream.avail_in = count;

		err = inflate( &d_stream, Z_NO_FLUSH );
		mydebug("@%d: inflate() = %d\n", __LINE__, err);

		if (err == Z_STREAM_END) 
		{
			mydebug("@%d: inflate() == Z_STREAM_END\n", __LINE__);
			break;
		}
		        
		if (err != Z_OK) 
		{
			mydebug("@%d: inflate() != Z_OK\n", __LINE__);
			goto bail_out; // to large inflate
		}
	}

	/*
	**	Finish the unzipping
	*/
	err = inflateEnd(&d_stream);
	mydebug("@%d: inflateEnd() = %d\n", __LINE__, err);

	if( (err != Z_OK) ||
	    (d_stream.total_out != (hdr->ContentSize + 8)) ||
	    (d_stream.total_in  != compressedLen ))
	{
		mydebug("@%d: TMDL_ERR_TDF_CRC_INCORRECT\n", __LINE__);
		tmRetVal = TMDL_ERR_TDF_CRC_INCORRECT;      // compressed size should match as well
	}

	//Copy back the 8 bytes overwritten at un-compressing
	memcpy(startaddr-8, copy, 8);

	if (tmRetVal == 0)
	{
		mydebug("@%d: total_count = %d\n", __LINE__, total_count);
		return tmbtAuth_Compare(sig);
	}

	bail_out:    
	mydebug("@%d: ERROR\n", __LINE__);

	return tmRetVal;
}
#endif

static int ReadLzoCompressedSignedTDF( void *pFile, TdfHeader_t 	*hdr, 
													  TdfPayloadHeader_t 		*pld, 
													  TdfPayloadHeader_t 		*pld1, 
													  unsigned long 			*sig, 
													  unsigned char 			*startaddr )
{
	unsigned int    tmRetVal = 0;
	long            count, total_count;
    unsigned        leftToReadLen;
	unsigned        thisReadLen;
	int             i;
	unsigned        compressedLen;    
	unsigned char   copy[8];                   // copy for the 8 bytes before startaddr
	//unsigned char   *pcheck = startaddr;
	
	// compressed payload - direct one block at a time
	total_count = pld1->payloadSize - sizeof(TdfSignedPayload_t) - sizeof(TdfPayloadHeader_t);
	mydebug("total_count = %ld\n", total_count);

	compressedLen = pld->payloadSize;
	mydebug("compressedLen = %d\n", compressedLen);

	/*  
	**  total amount of data we have to read (all the compressed data)
	*/
	leftToReadLen = total_count;                         

	/*  
	**  First pass startaddr.
	**  The compressed data contains a header. To get the real on the correct spot the
	**  destination needs to be substracted with 8
	*/
	memcpy(copy, startaddr-8, 8);
	tmbtAuth_Dispatch((void *)( (unsigned int)startaddr - 8 ), 4, AUTH_LZO_INIT, 1);

	for (i=0;;i++) {
		thisReadLen = MIN( leftToReadLen, COMP_BLOCK_SIZE); // size we read this iteration

		/* Wait tm authentication finishes the previous chunk before writing new data
		     if authentication is done by TM.
		*/
		pCompData = &(compData[0]);
		count = fread( pCompData, thisReadLen, 1, NULL);
	  	total_count -= count;
		mydebug("count = %ld\n", count);

#if 0
		// Invalidate 128kb for the uncompressed data area,
		// since uncompressing is done in avdsp
		mydebug("pcheck=%x\n", pcheck);
		invalidate_dcache_range( (ulong)pcheck, pcheck + COMP_BLOCK_SIZE);
		pcheck += COMP_BLOCK_SIZE;
#endif

		if (total_count <= 0) {			
			/*
			**	This is the Last Chunk. Finish the SHA256 hashing 
			*/
			tmbtAuth_Dispatch(pCompData, count, AUTH_SHA_LAST, 1);
			break;
		} else {
			tmbtAuth_Dispatch(pCompData, count, AUTH_SHA_NEXT, 1);
		}

		pCompData = &(compData[1]);
		count = fread( pCompData, thisReadLen, 1, NULL);
	  	total_count -= count;
		mydebug("count = %d\n", count);

#if 0
		// Invalidate 128kb for the uncompressed data area,
		// since uncompressing is done in avdsp
		mydebug("pcheck=%x\n", pcheck);
		invalidate_dcache_range( (ulong)pcheck, pcheck + COMP_BLOCK_SIZE);
		pcheck += COMP_BLOCK_SIZE;
#endif

		if (total_count <= 0) {			
			/*
			**	This is the Last Chunk. Finish the SHA256 hashing 
			*/
			tmbtAuth_Dispatch(pCompData, count, AUTH_SHA_LAST, 1);
			break;
		} else {
			tmbtAuth_Dispatch(pCompData, count, AUTH_SHA_NEXT, 1);
		}

		// invalidate data memory
	}

	tmbtAuth_Dispatch(pCompData, count, AUTH_SHA_GOODBYE, 1);

	//Copy back the 8 bytes overwritten at un-compressing
	memcpy(startaddr-8, copy, 8);

	if (tmRetVal == 0)
	{
		mydebug("total_count = %ld\n", total_count);
		return tmbtAuth_Compare(sig);
	}

bail_out:    
	myinfo("ERROR\n");

	return tmRetVal;
}

