#include "wrapper.h"
#include "rsa.h"

/*
**	Workarea needed by the RSA algorithm
*/
//unsigned char	wa[2048];

#if 0
//pub.key
unsigned long TdfPublicKey[128] =
{
	0x5e0e8341, 0xd00204d1, 0xf6bfd4ea, 0x213101c7, 0xe572aa4e, 0x1e339e78, 0x08bc3e0f, 0x81a6332c, 
	0xca0a9653, 0x79eb87e8, 0x547bc0fa, 0xc9f28d7f, 0x28820304, 0xc57faddf, 0x67ff0f6d, 0xfc596df5, 
	0x41608965, 0x53b87b44, 0xfa947de4, 0xe9044c1c, 0x776218e1, 0x2676091a, 0x4870dcd3, 0x8b75754e, 
	0xf199e0de, 0x2809a3ba, 0xadaa3f21, 0xccd94700, 0x7f04596d, 0xe7f8139a, 0x50f97084, 0xfa82b8ef, 
	0x3863a984, 0x6360ba4e, 0x36e3ccd0, 0x27213821, 0xdb1ac22e, 0x03cae88c, 0xcb393526, 0x7e134690, 
	0x0aaaa5d9, 0x350d86ab, 0xeff0ce5f, 0x1b3d6dba, 0xe619af24, 0x04f85cef, 0xe75d0323, 0xb0a6cc66, 
	0xbd0452fe, 0x890d2ef2, 0x0e25a946, 0xdeaf0099, 0x585b186e, 0xa6ac761d, 0x37f2ef32, 0x9c0ba722, 
	0xc40be6eb, 0x0431c1d1, 0x4c32392d, 0x774f6985, 0x06c992eb, 0x94cfe089, 0x0562d16b, 0xbfc64eb9,
	0x00010001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000
};
#endif

#ifdef CONFIG_USE_FAT_FS
//static unsigned char *pFileContent = (unsigned char *)0x01000000;
//YW: todo - replace hard-coded cluster size
static unsigned char firstChunk[0x1000]; // in case of vfat, this is the 1st cluster
static int           firstread = 0;
fsdata               datablock;	 
fsdata               *mydata = &datablock;
dir_entry            *direntry;	

static unsigned char *pCurrentPos;

extern long do_fat_open(const char *filename, void *buffer, unsigned long maxsize,	
							int dols, fsdata *mydata, dir_entry **dentry);
extern long get_contents_next(fsdata *mydata, dir_entry *dentptr, __u8 *buffer, 
							unsigned long maxsize, int isfirtread);

// Open a file and read the data from the 1st cluster
void *fopen(char *fname, char *mode) {
	long ret;

	mydebug("Open file %s\n", fname);
	pCurrentPos = NULL;

	//buffer/maxsize is not used at open
	ret = do_fat_open(fname, NULL, 0, LS_NO, mydata, &direntry);

	if (ret == 0) {
		firstread = get_contents_next(mydata, direntry, firstChunk, 0x1000, 1);
		mydebug("====>1st read: firstread:0x%x\n", firstread);
		
		if (firstread > 0) {
			pCurrentPos = firstChunk;
		}
	}	

	return pCurrentPos;
}


/* 
	a) Read (*psize * num) bytes from pCurrentPos, in case it's still in the 1st cluster;
   	b) Read from file
*/
unsigned long fread(unsigned char *pdest, unsigned long size, int nobj, void *fp) {
	unsigned long toread;
	int avail = (pCurrentPos==NULL) ? 0 : (firstChunk + firstread - pCurrentPos);
	
	toread = size * nobj;
	mydebug("======>pCurrentPos:0x%lx, toread: %lx, avail=0x%x\n", 
		pCurrentPos, toread, avail);

	if (avail > 0) {
		toread = min(avail, toread);
		mydebug("read from buffer for 0x%lx (%ld) bytes\n", toread, toread);
		memcpy(pdest, pCurrentPos, toread);

		pCurrentPos += toread;

		if (pCurrentPos >= (firstChunk + firstread) ) {
			// all data in the buffer is used
			myinfo("1st read is used up..............\n");
			pCurrentPos = NULL;
		}
	} else {
		// Read from file
		mydebug("read from file for 0x%lx (%ld) bytes\n", toread, toread);
		toread = get_contents_next(mydata, direntry, pdest, toread, 0);
		mydebug("actualread:0x%lx\n", toread);
	}
		
	return toread;
}

int fclose(void *fp) {
	return 0;
}

#endif

void ShowTTDFHeader(TdfHeader_t *tdf_hdr)
{
#ifdef MYDEBUG
	//printf("......TTDFHeader size: 0x%x (%d)\n",
	//	sizeof(struct TTDFHeader), sizeof(struct TTDFHeader));
    printf("struct TTDFHeader, size: 0x%x (%d)\n",
		sizeof(TdfHeader_t), sizeof(TdfHeader_t) );
    printf("\tUINT32  iMagicNumber      = 0x%08lx\n", (unsigned long)tdf_hdr->Magic);                             
    printf("\tUINT32  iHeaderSize       = 0x%08lx\n", (unsigned long)tdf_hdr->HeaderSize         );                              
    printf("\tUINT32  iVersion          = 0x%08lx\n", (unsigned long)tdf_hdr->TdfVersion            );                                 
    printf("\tUINT32  iCPUType          = 0x%08lx\n", (unsigned long)tdf_hdr->CpuType            );                                 
    printf("\tUINT32  iFileType         = 0x%08lx\n", (unsigned long)tdf_hdr->FileType           );                                
    printf("\tUINT32  iContentSize      = 0x%08lx\n", (unsigned long)tdf_hdr->ContentSize        );                             
    printf("\tUINT32  iChecksum         = 0x%08lx\n", (unsigned long)tdf_hdr->ContentCrc);                                
    printf("\tUINT32  iVirtualAddress   = 0x%08lx\n", (unsigned long)tdf_hdr->pVAddress     );                          
    printf("\tUINT32  iPhysicalAddress  = 0x%08lx\n", (unsigned long)tdf_hdr->pPAddress);                         
    printf("\tUINT32  iEntryPoint       = 0x%08lx\n", (unsigned long)tdf_hdr->pEntry);                              
    printf("\tUINT32  iAttributes       = 0x%08lx\n", (unsigned long)tdf_hdr->Attributes         );                              
    /// printf("\tUINT32  iStartSequenceLength = 0x%08x\n", (unsigned int)tdf_hdr->StartSequenceLength);                     
    //printf("UINT32  iStartSequence[TDF_MAX_SEQUENCE_LENGTH];        UINT32  iStartSequence[TDF_MAX_SEQUENCE_LENGTH];  
    /// printf("\tUINT32  iStopSequenceLength  = 0x%08x\n", (unsigned int)tdf_hdr->iStopSequenceLength );                      
    //printf("UINT32  iStopSequence[TDF_MAX_SEQUENCE_LENGTH];         UINT32  iStopSequence[TDF_MAX_SEQUENCE_LENGTH];   
#endif
}

void ShowTTDFPayloadHeader(TdfPayloadHeader_t *pl_hdr)
{
#ifdef MYDEBUG
	//printf("\n......TTDFPayloadHeader size: 0x%x (%d)\n",
	//	sizeof(struct TTDFPayloadHeader), sizeof(struct TTDFPayloadHeader));
	printf("\n......TTDFPayloadHeader size: 0x%x (%d)\n",
		sizeof(TdfPayloadHeader_t), sizeof(TdfPayloadHeader_t));
	printf("struct TdfPayloadHeader_t\n");
    printf("\tUINT32  iPayloadType = 0x%08x\n", (unsigned int)pl_hdr->payloadType);                             
    printf("\tUINT32  iPayloadSize = 0x%08x\n", (unsigned int)pl_hdr->payloadSize);                              
#endif	
}

void ShowTTDFSignedPayload(TdfSignedPayload_t *spl_hdr)
{
#ifdef MYDEBUG
	int paddinglen = sizeof(TdfSignedPayload_t) - 128;
	int i;
	
	printf("\n......TTDFSignedPayload size: 0x%x (%d)\n",
		sizeof(TdfSignedPayload_t), sizeof(TdfSignedPayload_t));
	printf("struct TTDFSignedPayload\n");

	mydebug("Padding ....paddinglen=%d\n", paddinglen);
	for (i=0; i<paddinglen; i++) {
		printf("%2x ", spl_hdr->padding[i]);
	} 
	printf("\n");

	printf("......RSA:\n");
	for (i=0; i<128; i++) {
		printf("%2x ", spl_hdr->rsa[i]);
		if ( (i+1) % 16 == 0 )
			printf("\n");
	}
	printf("\n");
#endif
}
    
	
/*
**	dump
**
**	Dumps the content of a array, great for debugging
**
*/
void dump(char *s, unsigned char *d, int l)
{
#ifdef MYDEBUG
	int k;

	printf(s);
	for (k = 0; k < l; k++)
	{
		printf((k & 15) ? " %02x" : "\n 	 %02x", d[k]);
	}			
	printf("\n\n");
#endif
}


