#undef MYDEBUG

#include "mont.h"
#include "tdfloader_local.h"
#include "tdfloader.h"

#include <common.h>
#include <config.h>
#include <asm/byteorder.h>

#ifdef CONFIG_USE_FAT_FS
#include <fat.h>
#endif

#define DCACHE_BYTES_PER_LINE 32

#define COMP_BLOCK_SIZE         (128*1024)
#define BUCKET_SZ               COMP_BLOCK_SIZE
#define BLOCK_SIZE				COMP_BLOCK_SIZE


#define CID_RESERVED	0x100U     
#define CID_LAYER_NONE	0x0U

extern void invalidate_dcache_range(ulong start_addr, ulong stop);

extern unsigned long fread(unsigned char *pdest, unsigned long size, int nobj, void *fp);
extern int fclose(void *fp);
extern void *fopen(char *fname, char *mode);
extern void DCacheIndexWritebackInvalidate(void);
extern void ShowTTDFHeader(TdfHeader_t *tdf_hdr);
extern void ShowTTDFPayloadHeader(TdfPayloadHeader_t *pl_hdr);
extern void ShowTTDFSignedPayload(TdfSignedPayload_t *spl_hdr);

extern void dump(char *s, unsigned char *d, int l);

